
package ThreadKernel;

$VERSION = "0.03";

use Input;
use ProgramBase;
use TB;
use DumbUI;

my $prim;
my $ui;
my $trace = 0;
my $current;

my $errormsg = '';

sub load {
    my $f = shift;

    if (open(IN, "<$f")) {
	Input->Stream(\*IN);
	if ($errors = $prim->Parse(1)) {
	    $errormsg = 'parse error';
	}
	close IN;
	$prim->Check;
	if ($r = $ui->GetErrors()) {
	    $errors += $r;
	    $errormsg = 'check error';
	}
	ProgramBase->Save($f, $prim->Mem);
	$current = $f;
	if ($errors) {
	    return 0;
	} else {
	    return 1;
	}
    } else {
	$errormsg = "could not open file '$f'";
	return 0;
    }
}

my $pollin;

sub PollInit {
    vec($pollin, fileno(STDIN), 1) = 1;
    vec($pollin, $ui->FileNoInput(), 1) = 1;
}

sub PollInput {

    select($pollout = $pollin, undef, undef, undef);
    if (vec($pollout, fileno(STDIN), 1)) {
	return "ctrl";
    } else {
	return "user";
    }
}

sub receivecommand {
    $request = PollInput();
#print STDERR "request: $request\n";
    if ($request eq "user") {
	$_ = $ui->ReadCommand;
    } else {
	$_ = TB->Receive;
    }
    return $_;
}

my $command = undef;

sub readcommand {
    my $c;
    
    if (defined $command) {
        $c = $command;
        $command = undef;
        return $c;
    } else {
        return receivecommand();
    }
}

sub disruptivecommand {
    my $c = shift;

    if ($c =~ /^l\s/) {
        return 1;
    } elsif ($c =~ /^lc\s/) {
        return 1;
    } elsif ($c =~ /^rr$/) {
        return 1;
    } elsif ($c =~ /^r\s/) {
        return 1;
    } elsif ($c =~ /^reset$/) {
        return 1;
    } elsif ($c =~ /^i$/) {
        return 1;
    } elsif ($c =~ /^q$/) {
        return 1;
    } else {
        return 0;
    }
}

sub waitstep {
    my $c;

    while (1) {
	$c = receivecommand();
#print STDERR "wait: $c\n";
	if (($c eq 's') || ($c eq 'r')) {
	    return 1;
	} elsif (disruptivecommand($c)) {
	    $command = $c;
	    return 0;
	} else {
	    execcommand($c);
	}
    }
}

sub NextStep {
    my $self = shift;

    if (defined $command) {
        return 0;
    }
    if ($ui->CheckStop(1)) {
        if (defined $::gui) {
            $ui->Ack;
        }
	TB->Send("done(0, 0)");
        if (waitstep()) {
            return 1;
        } else {
            return 0;
        }
    } else {
        return 1;
    }
}

sub Trace {
    return $trace;
}

sub Hold {
    return $Hold;
}

sub execcommand {
    $_ = shift;

	if (/^l\s+(\S+)$/) {
	    if (load($1)) {
		if (defined $::gui) {
		    $ui->SetNew($prim, $1);
		}
	    }
	} elsif (/^l$/) {
	    $p = join(", ", ProgramBase->List);
	    $ui->Msg("$p\n");
	    $ui->Msg("current: $current\n");
	} elsif (/^lc\s+(\S+)$/) {
	    $f = $1;
	    if (ProgramBase->Load($f, $prim->Mem)) {
		$current = $f;
		$prim->reset;
		$prim->ClearBreakpoints;
		if (defined $::gui) {
		    $ui->SetNew($prim, $f);
		}
	    } else {
		$ui->Msg("no program '$f' loaded\n");
	    }
	} elsif (/^list$/) {
	    $prim->Print(1);
	} elsif (/^r$/) {
	    if (! defined $::gui) {
		$ui->SetInterrupt;
	    }
	    $prim->Exec($trace);
	    $action->Update;
	    if (! defined $::gui) {
		$ui->ResetInterrupt;
	    }
	} elsif (/^rr$/) {
	    $prim->reset;
	    if (defined $::gui) {
		$ui->SetPC(0);
	    }
	    $prim->Exec($trace);
	    $action->Update;
	} elsif (/^r\s+(\S+)$/) {
	    $f = $1;
	    if (ProgramBase->Load($f, $prim->Mem)) {
		$current = $f;
		$prim->reset;
		if (defined $::gui) {
		    $ui->SetPC(0);
		}
		$prim->ClearBreakpoints;
		$prim->Exec($trace);
		$action->Update;
	    } else {
		$ui->Msg("no program '$f' loaded\n");
	    }
	} elsif (/^s$/) {
	    $cpc = ${"${prim}::pc"};
	    $r = $prim->ExecStep($trace);
#	    $action->Update;
	    if ($r == 1) {
		TB->Send("stop");
	    } else {
		$break = $prim->BreakpointOn(${"${prim}::pc"});
#print STDERR "done($cpc, $break)\n";
		TB->Send("done($cpc, $break)");
	    }
	} elsif (/^e\s+(.*\S)\s*$/) {
	    @i = $action->Parse($1);
	    if (defined $::gui) {
		$s = $action->Print(@i);
	    }
	    if ($i[0] eq 'ERROR') {
		if (defined $::gui) {
		    $ui->Msg("e: ERROR\n");
		} else {
		    $ui->Msg("parse error\n");
		}
	    } else {
		if (! defined $::gui) {
		    $ui->SetInterrupt;
		}
		$r = $action->Exec(@i);
		$action->Update;
		if (! defined $::gui) {
		    $ui->ResetInterrupt;
		}
		if (defined $::gui) {
		    $ui->Msg("e: $s    => " . ($r ? "T" : "F") . "\n");
		} else {
		    $ui->Msg(" $s    => " . ($r ? "T" : "F") . "\n");
		}
	    }
	} elsif (/^reset$/) {
	    $prim->reset;
	    if (defined $::gui) {
		$ui->SetPC(0);
	    }
	} elsif (/^t\s*(\+|-)$/) {
	    if ($1 eq '+') {
		$trace = 1;
		$ui->Msg("trace on\n");
	    } elsif ($1 eq '-') {
		$trace = 0;
		$ui->Msg("trace off\n");
	    }
	} elsif (/^b\s*(\+|-)\s*(\d+)$/) {
	    if ($1 eq '+') {
		$prim->BreakpointSet($2);
	    } elsif ($1 eq '-') {
		$prim->BreakpointUnset($2);
	    }
	} elsif (/^b$/) {
	    $prim->PrintBreakpoints;
	} elsif (/^b\s*c$/) {
	    $prim->ClearBreakpoints;
	} elsif (/^i$/) {
	    $prim->InitCore;
	    $action->Update;
	} elsif (/^d$/) {
	    $prim->DumpCore;
	} elsif (/^q$/) {
	    if (defined $::gui) {
		$ui->Quit;
	    }
	    last;
	} elsif (/^u\s*(\+|-)$/) {
	    if ($1 eq '+') {
		$action->SetUpdate(1);
	    } else {
		$action->SetUpdate(0);
	    }
	} elsif (/^\?$/) {
	    $ui->Msg("commands:\n");
	    $ui->Msg("    l <file>   - load program from file and makes it the current one\n");
	    $ui->Msg("    l          - lists loaded programs\n");
	    $ui->Msg("    lc <name>  - make program name the current if previously loaded\n");
	    $ui->Msg("    list       - list current program\n");
	    $ui->Msg("    r          - run current program (stopped by Ctrl-C)\n");
	    $ui->Msg("    r <name>   - make program name the current if previously loaded, and run it\n");
	    $ui->Msg("    rr         - rerun - reset and run\n");
	    $ui->Msg("    s          - step - execute one instruction\n");
	    $ui->Msg("    e <action> - execute action\n");
	    $ui->Msg("    reset      - reset program counter\n");
	    $ui->Msg("    t +/-      - trace on/off\n");
	    $ui->Msg("    b +/- <n>  - set/unset breakpoint on line <n>\n");
	    $ui->Msg("    b          - list breakpoints\n");
	    $ui->Msg("    b c        - clear all breakpoints\n");
	    $ui->Msg("    i          - initialize core\n");
	    $ui->Msg("    d          - dump core\n");
	    $ui->Msg("    u +/-      - enables/disables updates of core during a command\n");
	    $ui->Msg("    q          - quit\n");
	} else {
	    $ui->Msg("???\n");
	}
	if (defined $::gui) {
	    if ($request eq "user") {
		$ui->Ack;
	    }
	}
}

sub Run {
    my $self = shift;
    $prim = shift;
    $gui = shift;

    $ui = 'DumbUI';
    $ui->Init; # setup
    while ($f = shift @::loadlist) {
	if (load($f)) {
	    TB->Send("ok");
	    $ui = $gui;
	    $ui->Init;
	    if (defined $::gui) {
		$ui->SetNew($prim, $f);
	    }
	} else {
	    TB->Send("error($errormsg)");
#	    return;
	}
    }
    if (defined $::gui) {
	$ui->Ack;
    }
    if (defined $::programcounter) {
	${"${prim}::pc"} = $::programcounter;
	if (defined $::gui) {
	    $ui->SetPC($::programcounter);
	}
    }
    $action = $prim->Action;
    PollInit();
    while (1) {
	$_ = readcommand();
	execcommand($_);
    }
}

1;
