
package Thr;

$VERSION = "0.00";

sub Init {
    my $self = shift;

    $action = shift;
}

sub InitCore {
    my $self = shift;

    if (defined $action) {
	$action->InitCore;
    }
}

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
        $i = $1;
    }
    if ($i =~ /^fork \#(\d+)$/) {
	@prim = ('THRCREATE', $1);
    } else {
	if (defined $action) {
	    @prim = $action->Parse($i);
	} else {
	    @prim = ('ERROR');
	}
    }
    return @prim;
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $k;

    $opc = shift @i;
    if ($opc eq 'THRCREATE') {
	$k = shift @i;
	return "fork #$k";
    } else {
	if (defined $action) {
	    return $action->Print($opc, @i);
	} else {
	    return "";
	}
    }
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $k;

    $opc = shift @i;
    if ($opc eq 'THRCREATE') {
	$k = shift @i;
	# get pc, there must be a cleaner way
	$pc = ${"${::lang}::pc"};
	$k += $pc;
	TB->Send("thread(create $k)");
	$ack = TB->Receive;
	$ack =~ /^ack\((\d)\)$/;
	return $1;
    } else {
	unshift @i, $opc;
	return $action->Exec(@i);
    }
}

1;
