
package TUI;

$VERSION = "0.10";

use Display;
# inherit methods from Display
@ISA = qw( Display );

sub ReadCommand {
    my $c;

    Display->Msg("-> ");
    # when reading from file we have to deal with eof
    do {
	$c = <>;
    } while (! $c);
    chop $c;
    if ($c =~ /^\s*(.*\S)\s*$/) {
	$c = $1;
    }
    if ($ARGV ne '-') {
	# echo command when reading from file
	Display->Msg("$c\n");
    }
    return $c;
}

sub stop {
    $stop = 1;
}

sub SetInterrupt {
    $oldint = $SIG{INT};
    $SIG{INT} = \&stop;
    $stop = 0;
}

sub ResetInterrupt {
    $SIG{INT} = $oldint;
}

sub CheckStop {
    shift;
    if ($stop ) {
	if ($#_ == -1 || $_[0] == 0) {
	    Display->Msg("stopped\n");
	}
    }
    return $stop;
}

sub Init {
}

1;
