
package SLabel;

$VERSION = "0.00";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^L(\d+|\"[^\"]*\")$/) {
	    $prog[$ic ++] = [( 'LABEL', $1 )];
	} elsif ($i =~ /^##L(\d+|\"[^\"]*\")$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^R##L(\d+|\"[^\"]*\")$/) {
	    $prog[$ic ++] = [( 'RETGOTO', $1, '?' )];
	} else {
            @basic = $action->Parse($i);
            $prog[$ic ++] = [( 'ACTION', @basic )];
	}
        if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	return "L$l";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "##L$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'RETGOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "R##L$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $opc;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($attr) {
	    if ($opc ne 'LABEL') {
		$s .= indent($indent);
	    }
	}
	$s .= $self->PrintStep($attr, @i);
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;
    my @ni;
    my $nopc;

    # check for labels of goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
        @i = @{$prog[$ic]};
        $opc = shift @i;
        if ($opc eq 'LABEL') {
            $label{shift @i} = $ic;
        }
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO' || $opc eq 'RETGOTO') {
	    $l = shift @i;
            if (defined $label{$l}) {
                pop @{$prog[$ic]};
                push @{$prog[$ic]}, $label{$l};
            } else {
                $ui->Error("$ic: no label $l found\n");
                pop @{$prog[$ic]};
                push @{$prog[$ic]}, -1;
            }
	}
    }
}

sub reset {
    $pc = 0;
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

1;
