
namespace eval ProgView {
    variable wprog
    variable wname
    variable bp
    variable pc -1
    variable enabled 1

    package provide ProgView 0.03
}

proc ProgView::Init {wp wn} {
    variable wprog
    variable wname
    variable foreground
    variable background
    variable breakpointbg

    set wprog $wp
    set wname $wn

    set foreground [$wprog cget -foreground]
    set background [$wprog cget -background]
    if {$background == "#ffffff"} {
	set breakpointbg gray80
    } else {
	set breakpointbg white
	set breakpointbg gray80
    }
    $wprog tag configure JUMP -foreground green
}

proc ProgView::AddLine {l} {
    variable wprog
    variable bp

    regexp {^[ ]*([0-9]+) (.*)$} $l match nr
    if {[regexp {^(.*) (\([0-9]+\))(;\\n)$} $l match instr jump end] ||
	[regexp {^(.*) (\([0-9]+\))(\\n)$} $l match instr jump end]} {
	$wprog insert end [subst -nocommands -novariables "$instr"] LINE$nr
	$wprog insert end [subst -nocommands -novariables "$jump"] JUMP
	$wprog insert end [subst -nocommands -novariables "$end"] LINE$nr
	$wprog tag configure JUMP -foreground gray
    } else {
	$wprog insert end [subst -nocommands -novariables "$l"] LINE$nr
    }
    $wprog tag bind LINE$nr <ButtonPress-1> " ProgView::SetBreakpoint $nr 1 "
    set bp($nr) 0
}

proc ProgView::PC {new} {
    variable wprog
    variable pc
    variable foreground

    if {$pc != -1} {
	$wprog tag configure LINE$pc -foreground $foreground
    }
    set pc $new
    $wprog tag configure LINE$pc -foreground blue
}

proc ProgView::Program {p} {
    variable wprog
    variable wname
    variable pc

    set pc -1
    $wprog delete 0.0 end
    eval $wprog tag delete [$wprog tag names]
#    $wname delete 0 end
#    $wname insert 0 $p
    ComboBox::SetEntry $wname $p
    ComboBox::AddNew $wname $p
}

proc ProgView::Disable {} {
    variable enabled

    set enabled 0
}

proc ProgView::Enable {} {
    variable enabled

    set enabled 1
}

proc ProgView::SetBreakpoint {nr d} {
    variable wprog
    variable bp
    variable enabled
    variable background
    variable breakpointbg

    if {! $enabled} {
	return
    }
    if {$bp($nr)} {
#	$wprog tag configure LINE$nr -background gray90
	$wprog tag configure LINE$nr -background $background
	set bp($nr) 0
    } else {
	$wprog tag configure LINE$nr -background $breakpointbg
	set bp($nr) 1
    }
    if {$d} {
	::SetBreakpoint $nr $bp($nr)
    }
}

proc ProgView::ClearBreakpoints {} {
    variable bp

    set n [array size bp]
    for {set i 0} {$i < $n} {incr i} {
	if {$bp($i)} {
	    ProgView::SetBreakpoint $i 0
	}
    }
}
