
package PIR;

$VERSION = "0.00";

require Exporter;
@ISA = qw( Exporter);
@EXPORT = qw (
    AllocPreg FreePreg AllocIreg FreeIreg AllocSreg FreeSreg
    getInstrLabel getLocalLabel
    OutputComment OutputPre OutputPost OutputInstr OutputLabel
    newatom
    getfield setfield removefield fieldexists
    gettype settype settype_v
    getvalue setvalue
    getvalue_int setvalue_int setvalue_intv
    getvalue_str setvalue_str setvalue_strv
    getfocus setfocus removefocus focusexists
    equal notequal equal_str equal_strv equal_int equal_intv
    gotolabel
    add_intv add_int sub_intv sub_int
    hasfirst_str first_str delfirst_str
    cvt_str_int cvt_int_str
    append_strv append_str
    read_str write_strv write_str
);

use Global;

### Registers ###

#@Preg = (P0, P1, P2, P3, P4, P5, P6, P7, P8, P9);
@Preg = (P0, P1, P2);

sub AllocPreg {
    my $r;

    @Preg || die "Out of P registers\n";
    $r = shift @Preg;
    return "\$$r";
}

sub FreePreg {
    my $r = shift;

    $r =~ /^\$(.\d+)$/;
    unshift @Preg, $1;
}

#@Ireg = (I0, I1, I2, I3, I4, I5, I6, I7, I8, I9);
@Ireg = (I0, I1);

sub AllocIreg {
    my $r;

    @Ireg || die "Out of I registers\n";
    $r = shift @Ireg;
    return "\$$r";
}

sub FreeIreg {
    my $r = shift;

    $r =~ /^\$(.\d+)$/;
    unshift @Ireg, $1;
}

#@Sreg = (S0, S1, S2, S3, S4, S5, S6, S7, S8, S9);
@Sreg = (S0, S1);

sub AllocSreg {
    my $r;

    @Sreg || die "Out of S registers\n";
    $r = shift @Sreg;
    return "\$$r";
}

sub FreeSreg {
    my $r = shift;

    $r =~ /^\$(.\d+)$/;
    unshift @Sreg, $1;
}

### end Registers ###

### Labels ###

sub getInstrLabel {
    my $i = shift;

    return "IL$i"
}

my $local_label_count = 0;

sub getLocalLabel {
    my $i;

    $i = $local_label_count ++;
    return "LL$i"
}

### end Labels ###

### Output ###

sub OutputComment {
    my $com = shift;

    print "# $com\n";
}

sub OutputPre {

    my $libdir = Global::Get('LIBDIR');

    print <<PRO;
.sub _init
    .local PerlHash focus
    focus = new PerlHash
    global "focus" = focus
    \$P0 = new PerlHash
    \$P0["_t"] = "atom"
    focus["null"] = \$P0

    .sym pmc input
    .sym pmc output
    getstdin input
    getstdout output
    global "input" = input
    global "output" = output

    _Main()
    end
.end

.sub _Main
    .local PerlHash focus
    focus = global "focus"
    .local PerlHash null
    null = focus["null"]
    .local pmc input
    input = global "input"
    .local pmc output
    output = global "output"

PRO
}

sub OutputPost {

    print <<PRO;

END:
    .pcc_begin_return
    .pcc_end_return
.end
PRO
}

sub OutputInstr {
    my $s = shift;

    print "    $s\n";
}

sub OutputLabel {
    my $l = shift;
    my $s;

    if ($#_ >= 0) {
	print "$l:        # $_[0]\n";
    } else {
	print "$l:\n";
    }
}

### end Output ###

### instructions ###

sub newatom {
    my $reg = shift;

    OutputInstr("$reg = new PerlHash");
}

sub getfield {
    my $p = shift;
    my $reg = shift;
    my $f = shift;

    OutputInstr("$p = $reg\[\"$f\"]");
}

sub setfield {
    my $reg = shift;
    my $f = shift;
    my $p = shift;

    OutputInstr("$reg\[\"$f\"] = $p");
}

sub removefield {
    my $reg = shift;
    my $f = shift;

    OutputInstr("delete $reg\[\"$f\"]");
}

sub fieldexists {
    my $reg = shift;
    my $x = shift;
    my $false = shift;
    my $i;

    $i = AllocIreg();
    OutputInstr("$i = defined $reg\[\"$x\"]");
    OutputInstr("unless $i goto $false");
    FreeIreg($i);
}

sub getfield_int {
    my $x = shift;
    my $reg = shift;
    my $f = shift;

    OutputInstr("$x = $reg\[\"$f\"]");
}

sub setfield_int {
    my $reg = shift;
    my $f = shift;
    my $x = shift;

    OutputInstr("$reg\[\"$f\"] = $x");
}

sub setfield_intv {
    my $reg = shift;
    my $f = shift;
    my $v = shift;

    OutputInstr("$reg\[\"$f\"] = $v");
}

sub getfield_str {
    my $x = shift;
    my $reg = shift;
    my $f = shift;

    OutputInstr("$x = $reg\[\"$f\"]");
}

sub setfield_str {
    my $reg = shift;
    my $f = shift;
    my $x = shift;

    OutputInstr("$reg\[\"$f\"] = $x");
}

sub setfield_strv {
    my $reg = shift;
    my $f = shift;
    my $v = shift;

    OutputInstr("$reg\[\"$f\"] = $v");
}

sub gettype {
    my $sreg = shift;
    my $reg = shift;

    getfield_str($sreg, $reg, "_t");
}

sub settype {
    my $reg = shift;
    my $sreg = shift;

    setfield_str($reg, "_t", $sreg);
}

sub settype_v {
    my $reg = shift;
    my $type = shift;

    setfield_strv($reg, "_t", "\"$type\"");
}

sub getvalue {
    my $preg = shift;
    my $reg = shift;

    getfield($preg, $reg, "_v");
}

sub setvalue {
    my $reg = shift;
    my $preg = shift;

    setfield($reg, "_v", $preg);
}

sub getvalue_int {
    my $ireg = shift;
    my $reg = shift;

    getfield_int($ireg, $reg, "_v");
}

sub setvalue_int {
    my $reg = shift;
    my $ireg = shift;

    setfield_int($reg, "_v", $ireg);
}

sub setvalue_intv {
    my $reg = shift;
    my $v = shift;

    setfield_intv($reg, "_v", $v);
}

sub getvalue_str {
    my $sreg = shift;
    my $reg = shift;

    getfield_str($sreg, $reg, "_v");
}

sub setvalue_str {
    my $reg = shift;
    my $sreg = shift;

    setfield_str($reg, "_v", $sreg);
}

sub setvalue_strv {
    my $reg = shift;
    my $v = shift;

    setfield_strv($reg, "_v", $v);
}

sub getfocus {
    my $preg = shift;
    my $x = shift;

    OutputInstr("$preg = focus[\"$x\"]");
}

sub setfocus {
    my $x = shift;
    my $preg = shift;

    OutputInstr("focus\[\"$x\"] = $preg");
}

sub removefocus {
    my $x = shift;

    OutputInstr("delete focus[\"$x\"]");
}

sub focusexists {
    my $x = shift;
    my $false = shift;
    my $i;

    $i = AllocIreg();
    OutputInstr("$i = defined focus[\"$x\"]");
    OutputInstr("unless $i goto $false");
    FreeIreg($i);
}

sub equal {
    my $p1 = shift;
    my $p2 = shift;
    my $false = shift;

#       OutputInstr("if $preg1 != $preg2 goto $false");
# Why can't if handle this?
    OutputInstr("ne_addr $p1, $p2, $false");
}

sub notequal {
    my $p1 = shift;
    my $p2 = shift;
    my $false = shift;

    OutputInstr("eq_addr $p1, $p2, $false");
}

sub equal_str {
    my $s1 = shift;
    my $s2 = shift;
    my $false = shift;

    OutputInstr("if $s1 != $s2 goto $false");
}

sub equal_strv {
    my $s1 = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("if $s1 != $v goto $false");
}

sub equal_int {
    my $i1 = shift;
    my $i2 = shift;
    my $false = shift;

    OutputInstr("if $i1 != $i2 goto $false");
}

sub equal_intv {
    my $i1 = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("if $i1 != $v goto $false");
}

sub gotolabel {
    my $l = shift;

    OutputInstr("goto $l");
}

### end instructions ###

### MSPio instructions ###

sub add_intv {
    my $reg1 = shift;
    my $v = shift;
    my $false = shift;

    if ($v == 1) {
	OutputInstr("inc $reg1");
    } else {;
	OutputInstr("$reg1 = $reg1 + $v");
    }
}

sub add_int {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("$reg1 = $reg1 + $reg2");
}

sub sub_intv {
    my $reg1 = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("unless $reg1 >= $v goto $false");
    if ($v == 1) {
	OutputInstr("dec $reg1");
    } else {;
	OutputInstr("$reg1 = $reg1 - $v");
    }
}

sub sub_int {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("unless $reg1 >= $reg2 goto $false");
    OutputInstr("$reg1 = $reg1 - $reg2");
}

sub hasfirst_str {
    my $sreg = shift;
    my $false = shift;
    my $ireg;

    $ireg = AllocIreg();
    OutputInstr("length $ireg, $sreg");
    OutputInstr("unless $ireg > 0 goto $false");
    FreeIreg($ireg);
}

sub first_str {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("substr $reg1, $reg2, 0, 1");
}

sub delfirst_str {
    my $reg = shift;
    my $false = shift;

    OutputInstr("substr $reg, $reg, 1");
}

sub cvt_str_int {
    my $ireg = shift;
    my $sreg2 = shift;
    my $false = shift;
    my $sreg1;

    $sreg1 = AllocSreg();
    # convert to int by assignment, take the absolute value and convert
    # it back, then compare
    OutputInstr("$ireg = $sreg2");
    OutputInstr("abs $ireg");
    OutputInstr("$sreg1 = $ireg");
    OutputInstr("unless $sreg1 == $sreg2 goto $false");
    FreeSreg($sreg1);
}

sub cvt_int_str {
    my $sreg = shift;
    my $ireg = shift;
    my $false = shift;

    OutputInstr("$sreg = $ireg");
}

sub append_strv {
    my $reg = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("concat $reg, $v");
}

sub append_str {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("concat $reg1, $reg2");
}

sub read_str {
    my $sreg = shift;
    my $false = shift;

    OutputInstr("read $sreg, input, 1");
    OutputInstr("if $sreg == \"\" goto $false");
}

sub write_strv {
    my $v = shift;
    my $false = shift;

    OutputInstr("print output, $v");
}

sub write_str {
    my $reg = shift;
    my $false = shift;

    OutputInstr("print output, $reg");
}

### end MSPio instructions ###

1;
