
package PGLNull;

$VERSION = "0.00";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	@basic = $action->Parse($i);
	$prog[$ic ++] = [( 'ACTION', @basic )];
        if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
	return "$s";
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	if ($attr) {
	    $s .= indent($indent);
	}
	$s .= $self->PrintStep($attr, @i);
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;

}

sub reset {
    $pc = 0;
}

sub ExecStep {
    my $self = shift;
    my $trace = shift;
    my @i;
    my $opc;
    my $s;
    my $n;
    my $ended = 0;

    $result = "N";
    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("inaction (pc = $pc)\n");
	return;
    }
    @i = @{$prog[$pc]};
    if ($trace) {
	$s = $self->PrintStep(1, @i);
	$ui->Msg(" $pc: $s");
    }
    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$result = $action->Exec(@i);
	if ($trace) {
	    $ui->Msg("    => " . ($result ? "T" : "F"));
	}
	$pc ++;
    }
    if ($trace) {
	$ui->Msg("\n");
    }
    if ($::gui) {
	$ui->SetPC($pc);
    }
    if ($ended) {
	$ui->Msg("ended (pc = $pc)\n");
    }
    return $ended;
}

sub Exec {
    my $self = shift;
    my $trace = shift;
    my $ended = 0;

    while ($pc >= 0 && $pc <= $#prog && ! $ended) {
	$ended = $self->ExecStep($trace);
	if ($self->BreakpointOn($pc)) {
            $ui->Msg("break ($pc)\n");
            last;
        }
	if ($ui->CheckStop) {
	    last;
	}
    }
    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("inaction (pc = $pc)\n");
    }
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

sub getpc {
    return $pc;
}

1;
