
package PGLEcw;

$VERSION = "0.04";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^!$/) {
	    $prog[$ic ++] = [( 'END' )];
	} elsif ($i =~ /^L(\d+)$/) {
	    $prog[$ic ++] = [( 'LABEL', $1 )];
	} elsif ($i =~ /^##L(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^\}\{$/) {
	    $prog[$ic ++] = [( 'ELSE', '?' )];
	} elsif ($i =~ /^\}$/) {
	    $prog[$ic ++] = [( 'ENDIF', '?' )];
	} elsif ($i =~ /^\+(.+)\{$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'IFT', @basic, '?' )];
	} elsif ($i =~ /^-(.+)\{$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'IFF', @basic, '?' )];
	} elsif ($i =~ /^\+(.+)\{\*$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'WHILET', @basic, '?' )];
	} elsif ($i =~ /^\-(.+)\{\*$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'WHILEF', @basic, '?' )];
	} elsif ($i =~ /^{\*$/) {
	    $prog[$ic ++] = [( 'WHILE', '?' )];
	} elsif ($i =~ /^\*}$/) {
	    $prog[$ic ++] = [( 'ENDWHILE', '?' )];
	} elsif ($i =~ /^\+(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTT', @basic )];
	} elsif ($i =~ /^-(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTF', @basic )];
	} else {
	    @basic = $action->Parse($i);
	    $prog[$ic ++] = [( 'ACTION', @basic )];
	}
	if ($basic[0] eq 'ERROR') {
	    $error ++;
	    @basic = ();
	    $prog[$ic - 1] = [( 'ERROR', $i )];
	}
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
	return "$s";
    } elsif ($opc eq 'TESTT') {
	$s = $action->Print(@i);
	return "+ $s";
    } elsif ($opc eq 'TESTF') {
	$s = $action->Print(@i);
	return "- $s";
    } elsif ($opc eq 'END') {
	return "!";
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	return "L$l";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "##L$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'IFT') {
	$n = pop @i;
	$s = $action->Print(@i);
	$s = "+ $s {";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'IFF') {
	$n = pop @i;
	$s = $action->Print(@i);
	$s = "- $s {";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'ELSE') {
	$n = pop @i;
	$s = "}{";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'ENDIF') {
	$n = pop @i;
	$s = "}";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'WHILET') {
	$n = pop @i;
	$s = $action->Print(@i);
	$s = "+ $s {*";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'WHILEF') {
	$n = pop @i;
	$s = $action->Print(@i);
	$s = "- $s {*";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'WHILE') {
	$n = pop @i;
	$s = "{*";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'ENDWHILE') {
	$n = pop @i;
	$s = "*}";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my $i;
    my $ic;
    my $opc;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($opc eq 'ERROR') {
	    $s .= "Error: $i[1]";
	} else {
	    if ($opc eq 'ELSE' || $opc eq 'ENDIF' || $opc eq 'ENDWHILE') {
		$indent --;
	    }
	    if ($attr) {
		if ($opc ne 'LABEL') {
		    $s .= indent($indent);
		}
	    }
	    $s .= $self->PrintStep($attr, @i);
	    if ($opc eq 'IFT' || $opc eq 'IFF' || $opc eq 'ELSE'
		|| $opc eq 'WHILET' || $opc eq 'WHILEF' || $opc eq 'WHILE') {
		$indent ++;
	    }
	}
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub findlabel {
    my $l = shift;
    my $ic;
    my @i;
    my $opc;
    my $tl;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'LABEL') {
	    $tl = shift @i;
	    if ($tl == $l) {
		return $ic;
	    }
	}
    }
    return -1;
}

sub findinstr {
    my $cic = shift;
    my $find = shift;
    my $ic;
    my @i;
    my $opc;

#    print "*** $cic: looking for $find\n";
    for ($ic = $cic + 1; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq $find) {
#	    print "*** $cic $ic: found $find\n";
	    pop @{$prog[$cic]};
	    push @{$prog[$cic]}, $ic + 1;
	    if ($find eq 'ELSE') {
		$ic = findinstr($ic, 'ENDIF');
		return $ic;
	    } elsif ($opc eq 'ENDIF') {
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, $ic + 1;
		return $ic;
	    } elsif ($opc eq 'ENDWHILE') {
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, $cic;
		return $ic;
	    }
	} elsif ($opc eq 'IFT' || $opc eq 'IFF') {
	    $ic = findinstr($ic, 'ELSE');
	} elsif ($opc eq 'WHILET' || $opc eq 'WHILEF' || $opc eq 'WHILE') {
	    $ic = findinstr($ic, 'ENDWHILE');
	} elsif ($opc eq 'ENDIF' && $find eq 'ELSE') {
#	    print STDERR "$cic: no matching " . (($find eq 'ELSE') ? "}{" : "}") . " found\n";
#	    pop @{$prog[$cic]};
#	    push @{$prog[$cic]}, -1;
	    pop @{$prog[$cic]};
	    push @{$prog[$cic]}, $ic + 1;
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $ic + 1;
	    return $ic;
	}
    }
    $ui->Error("$cic: no matching $find found\n");
    return $ic;
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;
    my @ni;
    my $nopc;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	# a test must be followed by a goto or termination
	if ($opc eq 'TESTT' || $opc eq 'TESTF') {
	    @ni = @{$prog[$ic + 1]};
	    $nopc = shift @ni;
	    if ($nopc ne 'GOTO' && $nopc ne 'END') {
		$ui->Error("$ic: test not followed by a ##Lk or !\n");
	    }
	}
    }
    # flow control
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'IFT' || $opc eq 'IFF') {
	    $ic = findinstr($ic, 'ELSE');
	} elsif ($opc eq 'WHILET' || $opc eq 'WHILEF' || $opc eq 'WHILE') {
	    $ic = findinstr($ic, 'ENDWHILE');
	}
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'ELSE' || $opc eq 'ENDIF' || $opc eq 'ENDWHILE') {
	    if (shift @i eq '?') {
		$ui->Error("$ic: no matching opening brace found\n");
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, -1;
	    }
	}
    }
    # check for labels of goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'LABEL') {
	    $label{shift @i} = $ic;
	}
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $l = shift @i;
	    if (defined $label{$l}) {
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, $label{$l};
	    } else {
		$ui->Error("$ic: no label $l found\n");
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, -1;
	    }
	}
    }
}

sub reset {
    $pc = 0;
}

sub ExecStep {
    my $self = shift;
    my $trace = shift;
    my @i;
    my $opc;
    my $r;
    my $l;
    my $s;
    my $ended = 0;

    if ($pc < 0) {
	$ui->Msg("error (pc = $pc)\n");
	return;
    }
    if ($pc > $#prog) {
	$ui->Msg("ended (pc = $pc)\n");
	return 1;
    }
    @i = @{$prog[$pc]};
    if ($trace) {
	$s = $self->PrintStep(1, @i);
	$ui->Msg(" $pc: $s");
    }
    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$r = $action->Exec(@i);
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
	$pc ++;
    } elsif ($opc eq 'TESTT') {
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'TESTF') {
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'END') {
#	$pc = $#prog + 1;
	$ended = 1;
    } elsif ($opc eq 'LABEL') {
	$pc ++;
    } elsif ($opc eq 'GOTO') {
	$pc = pop @i;
    } elsif ($opc eq 'IFT') {
	$l = pop @i;
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc = $l;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'IFF') {
	$l = pop @i;
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc = $l;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'ELSE') {
	$pc = pop @i;
    } elsif ($opc eq 'ENDIF') {
#	$pc ++;
	$pc = pop @i; # is $pc ++ except when there is no IF
    } elsif ($opc eq 'WHILET') {
	$l = pop @i;
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc = $l;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'WHILEF') {
	$l = pop @i;
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc = $l;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'WHILE') {
	$pc ++;
    } elsif ($opc eq 'ENDWHILE') {
#	$pc ++;
	$pc = pop @i; # is $pc ++ except when there is no WHILE
    }
    if ($trace) {
	$ui->Msg("\n");
    }
    if ($::gui) {
	$ui->SetPC($pc);
    }
    if ($ended) {
        $ui->Msg("ended (pc = $pc)\n");
    }
    return $ended;
}

sub Exec {
    my $self = shift;
    my $trace = shift;
    my $ended = 0;

    if ($pc > $#prog) {
	$ui->Msg("ended (pc = $pc)\n");
	return;
    }
    while ($pc >= 0 && $pc <= $#prog && ! $ended) {
	$ended = $self->ExecStep($trace);
	if ($self->BreakpointOn($pc)) {
	    $ui->Msg("break ($pc)\n");
	    last;
	}
	if ($ui->CheckStop) {
	    last;
	}
    }
    if ($pc < 0) {
	$ui->Msg("error (pc = $pc)\n");
    }
    if ($pc > $#prog) {
	$ui->Msg("ended (pc = $pc)\n");
	return;
    }
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

1;
