
package PGLEcm;

$VERSION = "0.11";

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

$method = '[a-zA-z][a-zA-z0-9-]*';
$object = '[a-zA-z][a-zA-z0-9-\+\.]*';

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^!$/) {
	    $prog[$ic ++] = [( 'END' )];
	} elsif ($i =~ /^L(\d+)$/) {
	    $prog[$ic ++] = [( 'LABEL', $1 )];
	} elsif ($i =~ /^##L(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^\}\{$/) {
	    $prog[$ic ++] = [( 'ELSE', '?' )];
	} elsif ($i =~ /^\}$/) {
	    $prog[$ic ++] = [( 'ENDIF', '?' )];
	} elsif ($i =~ /^\+(.+)\{$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'IFT', @basic, '?' )];
	} elsif ($i =~ /^-(.+)\{$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'IFF', @basic, '?' )];
	} elsif ($i =~ /^\+(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTT', @basic )];
	} elsif ($i =~ /^-(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTF', @basic )];
	} elsif ($i =~ /^($method)\((.*)\)\s*\{$/) {
	    $m = $1;
	    $a = $2;
	    $a =~ /^\s*(.*?)\s*$/;
	    $a = $1;
	    $a =~ s/\s*,\s*/,/g;
	    @args = split(",", $a);
	    $prog[$ic ++] = [( 'METHODDEF', $m, @args )];
	} elsif ($i =~ /^($object)\.($method)\((.*)\)\s*\{$/) {
	    # this should not be here
	    $c = $1;
	    $m = $2;
	    $a = $3;
	    $a =~ /^\s*(.*?)\s*$/;
	    $a = $1;
	    $a =~ s/\s*,\s*/,/g;
	    @args = split(",", $a);
	    $prog[$ic ++] = [( 'METHODDEF', "$c.$m", @args )];
	} elsif ($i =~ /^($method)\((.*)\)$/) {
	    $m = $1;
	    $a = $2;
	    $a =~ /^\s*(.*?)\s*$/;
	    $a = $1;
	    $a =~ s/\s*,\s*/,/g;
	    @args = split(",", $a);
	    $prog[$ic ++] = [( 'METHODCALL', "", $m, @args, '?' )];
	} elsif ($i =~ /^($object)\s*=\s*($method)\((.*)\)$/) {
	    $f = $1;
	    $m = $2;
	    $a = $3;
	    $a =~ /^\s*(.*?)\s*$/;
	    $a = $1;
	    $a =~ s/\s*,\s*/,/g;
	    @args = split(",", $a);
	    $prog[$ic ++] = [( 'ASSMETHODCALL', $f, "", $m, @args, '?' )];
	} elsif ($i =~ /^($object)\.($method)\((.*)\)$/) {
	    $c = $1;
	    $m = $2;
	    $a = $3;
	    $a =~ /^\s*(.*?)\s*$/;
	    $a = $1;
	    $a =~ s/\s*,\s*/,/g;
	    @args = split(",", $a);
	    $prog[$ic ++] = [( 'METHODCALL', $c, $m, @args, '?' )];
	} elsif ($i =~ /^($object)\s*=\s*($object)\.($method)\((.*)\)$/) {
	    $f = $1;
	    $c = $2;
	    $m = $3;
	    $a = $4;
	    $a =~ /^\s*(.*?)\s*$/;
	    $a = $1;
	    $a =~ s/\s*,\s*/,/g;
	    @args = split(",", $a);
	    $prog[$ic ++] = [( 'ASSMETHODCALL', $f, $c, $m, @args, '?' )];
	# METHODEND is covered by ENDIF
	} else {
	    @basic = $action->Parse($i);
	    $prog[$ic ++] = [( 'ACTION', @basic )];
	}
	if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	$i = $input->Next;
    }
    &reset;
#    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $x;
    my $c;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
	return "$s";
    } elsif ($opc eq 'TESTT') {
	$s = $action->Print(@i);
	return "+ $s";
    } elsif ($opc eq 'TESTF') {
	$s = $action->Print(@i);
	return "- $s";
    } elsif ($opc eq 'END') {
	return "!";
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	return "L$l";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "##L$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'IFT') {
	$n = pop @i;
	$s = $action->Print(@i);
	$s = "+ $s {";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'IFF') {
	$n = pop @i;
	$s = $action->Print(@i);
	$s = "- $s {";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'ELSE') {
	$n = pop @i;
	$s = "}{";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'ENDIF') {
	$n = pop @i;
	$s = "}";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'METHODDEF') {
	$l = shift @i;
	$a = join(", ", @i);
	return "$l($a){";
    } elsif ($opc eq 'METHODEND') {
	return "}";
    } elsif ($opc eq 'METHODCALL') {
	$c = shift @i;
	$l = shift @i;
	$n = pop @i;
	$s = "";
	if ($c ne "") {
	    $s .= "$c.";
	}
	$a = join(", ", @i);
	$s .= "$l($a)";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'ASSMETHODCALL') {
	$x = shift @i;
	$c = shift @i;
	$l = shift @i;
	$n = pop @i;
	$s =  "$x = ";
	if ($c ne "") {
	    $s .= "$c.";
	}
	$a = join(", ", @i);
	$s .= "$l($a)";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my $i;
    my $ic;
    my $opc;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($opc eq 'ELSE' || $opc eq 'ENDIF' || $opc eq 'METHODEND') {
	    $indent --;
	}
	if ($attr) {
	    if ($opc ne 'LABEL') {
		$s .= indent($indent);
	    }
	}
	$s .= $self->PrintStep($attr, @i);
	if ($opc eq 'IFT' || $opc eq 'IFF' || $opc eq 'ELSE' ||
	    $opc eq 'METHODDEF') {
	    $indent ++;
	}
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub findlabel {
    my $l = shift;
    my $ic;
    my @i;
    my $opc;
    my $tl;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'LABEL') {
	    $tl = shift @i;
	    if ($tl == $l) {
		return $ic;
	    }
	}
    }
    return -1;
}

sub findinstr {
    my $cic = shift;
    my $find = shift;
    my $ic;
    my @i;
    my $opc;

#    print "*** $cic: looking for $find\n";
    for ($ic = $cic + 1; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq $find) {
#	    print "*** $cic $ic: found $find\n";
	    pop @{$prog[$cic]};
	    push @{$prog[$cic]}, $ic + 1;
	    if ($find eq 'ELSE') {
		$ic = findinstr($ic, 'ENDIF');
		return $ic;
	    } else {
		# ENDIF
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, $ic + 1;
		return $ic;
	    }
	} elsif ($opc eq 'IFT' || $opc eq 'IFF') {
	    $ic = findinstr($ic, 'ELSE');
	} elsif ($opc eq 'ENDIF') {
#	    print STDERR "$cic: no matching " . (($find eq 'ELSE') ? "}{" : "}") . " found\n";
#	    pop @{$prog[$cic]};
#	    push @{$prog[$cic]}, -1;
	    pop @{$prog[$cic]};
	    push @{$prog[$cic]}, $ic + 1;
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $ic + 1;
	    return $ic;
	}
    }
    $ui->Error("$cic: no matching $find found\n");
    return $ic;
}

sub findend {
    my $cic = shift;
    my $ic;
    my @i;
    my $opc;
    my $level;

    $level = 0;
    for ($ic = $cic + 1; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'ENDIF') {
	    if ($level == 0) {
		return $ic;
	    } else {
		$level --;
	    }
	} elsif ($opc eq 'IFT' || $opc eq 'IFF') {
	    $level ++;
	}
    }
    return -1;
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;
    my @ni;
    my $nopc;
    my %methoddef;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	# a test must be followed by a goto or termination
	if ($opc eq 'TESTT' || $opc eq 'TESTF') {
	    @ni = @{$prog[$ic + 1]};
	    $nopc = shift @ni;
	    if ($nopc ne 'GOTO' && $nopc ne 'END') {
		$ui->Error("$ic: test not followed by a ##Lk or !\n");
	    }
	}
    }
    # flow control
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'IFT' || $opc eq 'IFF') {
	    $ic = findinstr($ic, 'ELSE');
	}
    }
    # find end of methods
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'METHODDEF') {
	    $end = findend($ic);
	    if ($end == -1) {
		$ui->Error("$ic: no end of method found\n");
	    } else {
		$prog[$end] = [( 'METHODEND' )];
	    }
	}
    }
    # check braces
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'ELSE' || $opc eq 'ENDIF') {
	    if (shift @i eq '?') {
		$ui->Error("$ic: no matching opening brace found\n");
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, -1;
	    }
	}
    }
    # check for labels of goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'LABEL') {
	    $label{shift @i} = $ic;
	}
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO' || $opc eq 'RETGOTO') {
	    $l = shift @i;
	    if (defined $label{$l}) {
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, $label{$l};
	    } else {
		$ui->Error("$ic: no label $l found\n");
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, -1;
	    }
	}
    }
    # method calls
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'METHODDEF') {
	    $n = shift @i;
	    $methoddef{$n} = $ic;
	}
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'METHODCALL' || $opc eq 'ASSMETHODCALL') {
	    if ($opc eq 'ASSMETHODCALL') {
		shift @i;
	    }
	    $c = shift @i;
	    $m = shift @i;
	    if ($c eq "") {
		$n = $m;
	    } else {
#		$n = "$c.$m";
		$n = "$m";
	    }
	    pop @{$prog[$ic]};
	    if (defined $methoddef{$n}) {
		push @{$prog[$ic]}, $methoddef{$n};
	    } else {
		$ui->Error("$ic: no method $n found\n");
		push @{$prog[$ic]}, -1;
	    }
	}
    }
}

sub reset {
    $pc = 0;
    @stack = (-1);
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

1;
