
package PGLEcTransSystem;
use TransSystem;
@ISA = qw(TransSystem);

$VERSION = "0.01";

sub new {
    my $type = shift;
    my $self = TransSystem->new;
    return bless $self, $type;
}

sub MakeTrans {
    my $self = shift;
    my $mem = shift;

    for ($i = 0; $i <= $#$mem; $i ++) {
	@instr = @{$$mem[$i]};
	$opc = shift @instr;
	$prelabel = shift @instr;
	$prelabel =~ s/ //g;
	if ($opc eq 'ACTION') {
#	    $self->AddState($i, @instr);
	    $self->AddTransition($i, $i + 1, "${prelabel}T");
	    $self->AddTransition($i, $i + 1, "${prelabel}F");
	} elsif ($opc eq 'TESTT') {
#	    $self->AddState($i, @instr);
	    $self->AddTransition($i, $i + 1, "${prelabel}T");
	    $self->AddTransition($i, $i + 2, "${prelabel}F");
	} elsif ($opc eq 'TESTF') {
#	    $self->AddState($i, @instr);
	    $self->AddTransition($i, $i + 1, "${prelabel}F");
	    $self->AddTransition($i, $i + 2, "${prelabel}T");
	} elsif ($opc eq 'END') {
#	    $self->AddState($i, '');
	} elsif ($opc eq 'LABEL') {
#	    $self->AddState($i, '');
	    $self->AddTransition($i, $i + 1, "tau");
	} elsif ($opc eq 'GOTO') {
#	    $self->AddState($i, '');
	    $n = pop @instr;
	    $self->AddTransition($i, $n, "tau");
	} elsif ($opc eq 'IFT') {
	    $n = pop @instr;
#	    $self->AddState($i, @instr);
	    $self->AddTransition($i, $i + 1, "${prelabel}T");
	    $self->AddTransition($i, $n, "${prelabel}F");
	} elsif ($opc eq 'IFF') {
	    $n = pop @instr;
#	    $self->AddState($i, @instr);
	    $self->AddTransition($i, $i + 1, "${prelabel}F");
	    $self->AddTransition($i, $n, "${prelabel}T");
	} elsif ($opc eq 'ELSE') {
#	    $self->AddState($i, '');
#	    $n = pop @instr;
	    $self->AddTransition($i, ${prelabel}, "tau");
	} elsif ($opc eq 'ENDIF') {
#	    $self->AddState($i, '');
#	    $n = pop @instr;
	    $self->AddTransition($i, ${prelabel}, "tau");
	} else {
	    die "$0: unknown instruction '$opc'\n";
	}
    }
}

1;
