
package PGLE;

$VERSION = "0.08";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^!$/) {
	    $prog[$ic ++] = [( 'END' )];
	} elsif ($i =~ /^L(\d+)$/) {
	    $prog[$ic ++] = [( 'LABEL', $1 )];
	} elsif ($i =~ /^##L(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^\+(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTT', @basic )];
	} elsif ($i =~ /^-(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTF', @basic )];
	} else {
	    @basic = $action->Parse($i);
	    $prog[$ic ++] = [( 'ACTION', @basic )];
	}
        if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
    } elsif ($opc eq 'TESTT') {
	$s = $action->Print(@i);
	return "+ $s";
    } elsif ($opc eq 'TESTF') {
	$s = $action->Print(@i);
	return "- $s";
    } elsif ($opc eq 'END') {
	return "!";
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	return "L$l";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "##L$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $opc;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($attr) {
	    if ($opc ne 'LABEL') {
		$s .= indent($indent);
	    }
	}
	$s .= $self->PrintStep($attr, @i);
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;
    my @ni;
    my $nopc;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	# a test must be followed by a goto or termination
	if ($opc eq 'TESTT' || $opc eq 'TESTF') {
	    @ni = @{$prog[$ic + 1]};
	    $nopc = shift @ni;
	    if ($nopc ne 'GOTO' && $nopc ne 'END') {
		$ui->Error("$ic: test not followed by a ##Lk or !\n");
	    }
	}
    }
    # check for labels of goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
        @i = @{$prog[$ic]};
        $opc = shift @i;
        if ($opc eq 'LABEL') {
            $label{shift @i} = $ic;
        }
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $l = shift @i;
            if (defined $label{$l}) {
                pop @{$prog[$ic]};
                push @{$prog[$ic]}, $label{$l};
            } else {
                $ui->Error("$ic: no label $l found\n");
                pop @{$prog[$ic]};
                push @{$prog[$ic]}, -1;
            }
	}
    }
}

sub reset {
    $pc = 0;
}

sub ExecStep {
    my $self = shift;
    my $trace = shift;
    my @i;
    my $opc;
    my $r;
    my $ended = 0;

    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("ended (pc = $pc)\n");
	return 1;
    }
    @i = @{$prog[$pc]};
    if ($trace) {
	$s = $self->PrintStep(1, @i);
	$ui->Msg(" $pc: $s");
    }
    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$r = $action->Exec(@i);
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
	$pc ++;
    } elsif ($opc eq 'TESTT') {
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'TESTF') {
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'END') {
#	$pc = $#prog + 1;
	$ended = 1;
    } elsif ($opc eq 'LABEL') {
	$pc ++;
    } elsif ($opc eq 'GOTO') {
	$pc = pop @i;
    }
    if ($trace) {
	$ui->Msg("\n");
    }
    if ($::gui) {
        $ui->SetPC($pc);
    }
    if ($ended) {
        $ui->Msg("ended (pc = $pc)\n");
    }
    return $ended;
}

sub Exec {
    my $self = shift;
    my $trace = shift;
    my $ended = 0;

    while ($pc >= 0 && $pc <= $#prog && ! $ended) {
	$ended = $self->ExecStep($trace);
        if ($self->BreakpointOn($pc)) {
            $ui->Msg("break ($pc)\n");
            last;
        }
        if ($ui->CheckStop) {
            last;
        }
    }
    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("ended (pc = $pc)\n");
    }
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

1;
