
package PGLBu;

$VERSION = "0.01";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^u\(\s*/) {
	    $prog[$ic ++] = [( 'UNITSTART', '?' )];
	    $i = $';
	}
	if ($i =~ /\s*\)$/) {
	    $endunit = 1;
	    $i = $`;
	} else {
	    $endunit = 0;
	}
	if ($i =~ /^!$/) {
	    $prog[$ic ++] = [( 'END' )];
	} elsif ($i =~ /^#(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^\\#(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTOB', $1, '?' )];
	} elsif ($i =~ /^\+(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTT', @basic )];
	} elsif ($i =~ /^-(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTF', @basic )];
	} else {
	    @basic = $action->Parse($i);
	    $prog[$ic ++] = [( 'ACTION', @basic )];
	}
        if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	if ($endunit) {
	    $prog[$ic ++] = [( 'UNITEND', '?' )];
	}
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
	return "$s";
    } elsif ($opc eq 'TESTT') {
	$s = $action->Print(@i);
	return "+ $s";
    } elsif ($opc eq 'TESTF') {
	$s = $action->Print(@i);
	return "- $s";
    } elsif ($opc eq 'END') {
	return "!";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "#$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'GOTOB') {
	$n = pop @i;
	$l = shift @i;
	$s = "\\#$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'UNITSTART') {
	$n = pop @i;
	$s = "u(";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'UNITEND') {
	$n = pop @i;
	$s = ")";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($opc eq 'UNITEND') {
	    $indent --;
	}
	if ($attr) {
	    $s .= indent($indent);
	}
	$s .= $self->PrintStep($attr, @i);
	if ($opc eq 'UNITSTART') {
	    $indent ++;
	}
	if ($ic == $#prog || $opc eq 'UNITSTART') {
	    $ui->List("$s\n");
	} else {
	    @i = @{$prog[$ic + 1]};
	    $opc = shift @i;
	    if ($opc eq 'UNITEND') {
		$ui->List("$s\n");
	    } else {
		$ui->List("$s;\n");
	    }
	}
    }
}

sub findendunit {
    my $cic = shift;
    my $ic;
    my @i;
    my $opc;

    for ($ic = $cic + 1; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'UNITEND') {
	    pop @{$prog[$cic]};
	    push @{$prog[$cic]}, $ic;
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $cic;
	    return $ic;
	} elsif ($opc eq 'UNITSTART') {
	    $ic = findendunit($ic);
	}
    }
    $ui->Error("$cic: no matching UNITEND found\n");
    return $ic;
}

sub unitnumber {
    my $c = shift;
    my $repeat = shift;

    for ($ic = $c - 1; $repeat; $ic --) {
	$repeat --;
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'UNITEND') {
	    $ic = pop @i;
	}
    }
    return $ic + 1;
}

sub findlabel {
    my $l = shift;
    my $ic = shift;

    if ($l == 0) {
	return $ic;
    }
    do {
	$l --;
	$ic ++;
NEXT:
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'UNITEND') {
	    $ic ++;
	    goto NEXT;
	}
	if (! $l) {
	    return $ic;
	}
	if ($opc eq 'UNITSTART') {
	    $ic = pop @i;
	}
    } while ($l);
    return $ic;
}

sub findlabelup {
    my $l = shift;
    my $ic = shift;

    do {
	$l --;
	$ic --;
NEXT:
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'UNITEND') {
	    $ic = pop @i;
	}
	if (! $l) {
	    return $ic;
	}
	if ($opc eq 'UNITSTART') {
	    $ic --;
	    goto NEXT;
	}
    } while ($l);
    return $ic;
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;
    my $repeatnr;
    my $x;

    # check units
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'UNITSTART') {
	    $ic = findendunit($ic);
	} elsif ($opc eq 'UNITEND') {
	    $ui->Error("$ic: no matching UNITSTART found\n");
	}
    }
    # resolve goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $l = shift @i;
	    $g = findlabel($l, $ic);
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $g;
	} elsif ($opc eq 'GOTOB') {
	    $l = shift @i;
	    $g = findlabelup($l, $ic);
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $g;
	}
    }
}

sub reset {
    $pc = 0;
}

sub ExecStep {
    my $self = shift;
    my $trace = shift;
    my @i;
    my $opc;
    my $r;
    my $s;

    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("error (pc = $pc)\n");
	return;
    }
    @i = @{$prog[$pc]};
    if ($trace) {
	$s = $self->PrintStep(1, @i);
	$ui->Msg(" $pc: $s");
    }
    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$r = $action->Exec(@i);
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
	$pc ++;
    } elsif ($opc eq 'TESTT') {
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'TESTF') {
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'END') {
	$pc = $#prog + 1;
    } elsif ($opc eq 'GOTO') {
	$pc = pop @i;
    } elsif ($opc eq 'GOTOB') {
	$pc = pop @i;
    }
    if ($trace) {
	$ui->Msg("\n");
    }
    if ($::gui) {
	$ui->SetPC($pc);
    }
}

sub Exec {
    my $self = shift;
    my $trace = shift;
    my $oldsig;

    while ($pc >= 0 && $pc <= $#prog) {
	$self->ExecStep($trace);
	if ($self->BreakpointOn($pc)) {
            $ui->Msg("break ($pc)\n");
            last;
        }
	if ($ui->CheckStop) {
	    last;
	}
    }
    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("error (pc = $pc)\n");
    }
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

1;
