
package PGLBg;

$VERSION = "0.01";

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^!$/) {
	    $prog[$ic ++] = [( 'END' )];
	} elsif ($i =~ /^##L(\d+(,\d+)*)$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^L(\d+(,\d+)*)$/) {
	    $prog[$ic ++] = [( 'LABEL', $1 )];
	} elsif ($i =~ /^\+(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTT', @basic )];
	} elsif ($i =~ /^-(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTF', @basic )];
	} else {
	    @basic = $action->Parse($i);
	    $prog[$ic ++] = [( 'ACTION', @basic )];
	}
	$i = $input->Next;
    }
    &reset;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
	return "$s";
    } elsif ($opc eq 'TESTT') {
	$s = $action->Print(@i);
	return "+ $s";
    } elsif ($opc eq 'TESTF') {
	$s = $action->Print(@i);
	return "- $s";
    } elsif ($opc eq 'END') {
	return "!";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "##L$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	return "L$l";
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($attr) {
	    if ($opc ne 'LABEL') {
		$s .= indent($indent);
	    }
	}
	$s .= $self->PrintStep($attr, @i);
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;

    # check for labels of goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'LABEL') {
	    $label{shift @i} = $ic;
	}
    }
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $l = shift @i;
	    if (defined $label{$l}) {
		pop @{$prog[$ic]};
		push @{$prog[$ic]}, $label{$l};
	    } else {
                $ui->Error("$ic: no label $l found\n");
                pop @{$prog[$ic]};
                push @{$prog[$ic]}, -1;
	    }
	}
    }
}

sub reset {
    $pc = 0;
}

sub ExecStep {
    my $self = shift;
    my $trace = shift;
    my @i;
    my $opc;
    my $r;

    if ($pc < 0) {
	$ui->Msg("error (pc = $pc)\n");
	return;
    }
    if ($pc > $#prog) {
	$ui->Msg("ended\n");
	return;
    }
    @i = @{$prog[$pc]};
    if ($trace) {
	$ui->Msg(" $pc: ");
	$self->PrintStep(1, @i);
    }
    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$r = $action->Exec(@i);
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
	$pc ++;
    } elsif ($opc eq 'TESTT') {
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'TESTF') {
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'END') {
	$pc = $#prog + 1;
    } elsif ($opc eq 'LABEL') {
	$pc ++;
    } elsif ($opc eq 'GOTO') {
	$pc = pop @i;
    }
    if ($trace) {
	$ui->Msg("\n");
    }
}

sub Exec {
    my $self = shift;
    my $trace = shift;

    while ($pc >= 0 && $pc <= $#prog) {
	$self->ExecStep($trace);
    }
    if ($pc < 0) {
	$ui->Msg("error (pc = $pc)\n");
    }
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

1;
