
package PGLB;

$VERSION = "0.05";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while ($i ne "") {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^!$/) {
	    $prog[$ic ++] = [( 'END' )];
	} elsif ($i =~ /^#(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTO', $1, '?' )];
	} elsif ($i =~ /^\\#(\d+)$/) {
	    $prog[$ic ++] = [( 'GOTOB', $1, '?' )];
	} elsif ($i =~ /^\+(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTT', @basic )];
	} elsif ($i =~ /^-(.+)$/) {
	    @basic = $action->Parse($1);
	    $prog[$ic ++] = [( 'TESTF', @basic )];
	} else {
	    @basic = $action->Parse($i);
	    $prog[$ic ++] = [( 'ACTION', @basic )];
	}
        if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
	return "$s";
    } elsif ($opc eq 'TESTT') {
	$s = $action->Print(@i);
	return "+ $s";
    } elsif ($opc eq 'TESTF') {
	$s = $action->Print(@i);
	return "- $s";
    } elsif ($opc eq 'END') {
	return "!";
    } elsif ($opc eq 'GOTO') {
	$n = pop @i;
	$l = shift @i;
	$s = "#$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    } elsif ($opc eq 'GOTOB') {
	$n = pop @i;
	$l = shift @i;
	$s = "\\#$l";
	if ($attr) {
	    $s .= "    ($n)";
	}
	return $s;
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	if ($attr) {
	    $s .= indent($indent);
	}
	$s .= $self->PrintStep($attr, @i);
	if ($ic == $#prog) {
	    $ui->List("$s\n");
	} else {
	    $ui->List("$s;\n");
	}
    }
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;

    # check for labels of goto's
    for ($ic = 0; $ic <= $#prog; $ic ++) {
	@i = @{$prog[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $l = shift @i;
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $ic + $l;
	} elsif ($opc eq 'GOTOB') {
	    $l = shift @i;
	    pop @{$prog[$ic]};
	    push @{$prog[$ic]}, $ic - $l;
	}
    }
}

sub reset {
    $pc = 0;
}

sub ExecStep {
    my $self = shift;
    my $trace = shift;
    my @i;
    my $opc;
    my $r;
    my $ended = 0;

    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("inaction (pc = $pc)\n");
	return;
    }
    @i = @{$prog[$pc]};
    if ($trace) {
	$s = $self->PrintStep(1, @i);
	$ui->Msg(" $pc: $s");
    }
    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$r = $action->Exec(@i);
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
	$pc ++;
    } elsif ($opc eq 'TESTT') {
	$r = $action->Exec(@i);
	if ($r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'TESTF') {
	$r = $action->Exec(@i);
	if (! $r) {
	    $pc ++;
	} else {
	    $pc += 2;
	}
	if ($trace) {
	    $ui->Msg("    => " . ($r ? "T" : "F"));
	}
    } elsif ($opc eq 'END') {
#	$pc = $#prog + 1;
	$ended = 1;
    } elsif ($opc eq 'GOTO') {
	$pc = pop @i;
    } elsif ($opc eq 'GOTOB') {
	$pc = pop @i;
    }
    if ($trace) {
	$ui->Msg("\n");
    }
    if ($::gui) {
        $ui->SetPC($pc);
    }
    if ($ended) {
        $ui->Msg("ended (pc = $pc)\n");
    }
    return $ended;
}

sub Exec {
    my $self = shift;
    my $trace = shift;
    my $ended = 0;

    while ($pc >= 0 && $pc <= $#prog && ! $ended) {
	$ended = $self->ExecStep($trace);
        if ($self->BreakpointOn($pc)) {
            $ui->Msg("break ($pc)\n");
            last;
        }
        if ($ui->CheckStop) {
            last;
        }
    }
    if ($pc < 0 || $pc > $#prog) {
	$ui->Msg("inaction (pc = $pc)\n");
    }
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

1;
