
package PGLATransSystem;

use TransSystem;
@ISA = qw(TransSystem);

$VERSION = "0.01";

sub new {
    my $type = shift;
    my $self = TransSystem->new;
    return bless $self, $type;
}

sub MakeTrans {
    my $self = shift;
    my $mem = shift;

    for ($i = 0; $i <= $#$mem; $i ++) {
	@instr = @{$$mem[$i]};
	$opc = shift @instr;
	$prelabel = shift @instr;
	$prelabel =~ s/ //g;
	if ($opc eq 'ACTION') {
#	    AddState($self, $i, @instr);
	    AddTransition($self, $i, $i + 1, "${prelabel}T");
	    AddTransition($self, $i, $i + 1, "${prelabel}F");
	} elsif ($opc eq 'TESTT') {
#	    AddState($self, $i, @instr);
	    AddTransition($self, $i, $i + 1, "${prelabel}T");
	    $n = pop @instr;
	    AddTransition($self, $i, $n, "${prelabel}F");
	} elsif ($opc eq 'TESTF') {
#	    AddState($self, $i, @instr);
	    AddTransition($self, $i, $i + 1, "${prelabel}F");
	    $n = pop @instr;
	    AddTransition($self, $i, $n, "${prelabel}T");
	} elsif ($opc eq 'END') {
#	    AddState($self, $i, '');
	} elsif ($opc eq 'GOTO') {
#	    AddState($self, $i, '');
	    $n = pop @instr;
	    AddTransition($self, $i, $n, "tau");
	} elsif ($opc eq 'REPEAT') {
#	    AddState($self, $i, '');
	    $n = pop @instr;
	    AddTransition($self, $i, $n, "tau");
	} else {
	    die "$0: unknown instruction '$opc'\n";
	}
    }
}

1;
