
package MSPio_CG;

$VERSION = "0.00";

use CG;
use Fluid_CG;
use HMPPV_CG;

@ISA = qw( HMPPV_CG Fluid_CG CG );

sub CG {
    my $self = shift;
    my $false = shift;
    my @i = @_;
    my $opc = shift @i;
    my ($x, $y, $v);
    my ($preg1, $preg2);
    my ($ireg1, $ireg2);
    my ($sreg1, $sreg2);

    if ($opc eq 'SUBST') {
	$x = shift @i;
    } elsif ($opc eq 'ESCAPE') {
	$x = shift @i;
    } elsif ($opc eq 'INCR') {
	$x = shift @i;
	$v = shift @i;
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'int', $false);
	$ireg1 = AllocIreg();
	getvalue_int($ireg1, $preg1);
	add_intv($ireg1, $v, $false);
	setvalue_int($preg1, $ireg1);
	FreeIreg($ireg1);
	FreePreg($preg1);
    } elsif ($opc eq 'INCRVAR') {
	$x = shift @i;
	$y = shift @i;
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'int', $false);
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, 'int', $false);
	$ireg1 = AllocIreg();
	getvalue_int($ireg1, $preg1);
	$ireg2 = AllocIreg();
	getvalue_int($ireg2, $preg2);
	add_int($ireg1, $ireg2, $false);
	setvalue_int($preg1, $ireg1);
	FreeIreg($ireg2);
	FreeIreg($ireg1);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'DECR') {
	$x = shift @i;
	$v = shift @i;
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'int', $false);
	$ireg1 = AllocIreg();
	getvalue_int($ireg1, $preg1);
	sub_intv($ireg1, $v, $false);
	setvalue_int($preg1, $ireg1);
	FreeIreg($ireg1);
	FreePreg($preg1);
    } elsif ($opc eq 'DECRVAR') {
	$x = shift @i;
	$y = shift @i;
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'int', $false);
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, 'int', $false);
	$ireg1 = AllocIreg();
	getvalue_int($ireg1, $preg1);
	$ireg2 = AllocIreg();
	getvalue_int($ireg2, $preg2);
	sub_int($ireg1, $ireg2, $false);
	setvalue_int($preg1, $ireg1);
	FreeIreg($ireg2);
	FreeIreg($ireg1);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'FIRST') {
	$y = shift @i;
	$x = shift @i;
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, 'str', $false);
	$sreg2 = AllocSreg();
	getvalue_str($sreg2, $preg2);
	hasfirst_str($sreg2, $false);
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'str', $false);
	$sreg1 = AllocSreg();
	first_str($sreg1, $sreg2, $false);
	setvalue_str($preg1, $sreg1);
	FreeSreg($sreg1);
	FreeSreg($sreg2);
	FreePreg($preg1);
	FreePreg($preg2);
    } elsif ($opc eq 'DELFIRST') {
	$x = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, 'str', $false);
	$sreg1 = AllocSreg();
	getvalue_str($sreg1, $preg1);
	hasfirst_str($sreg1, $false);
	delfirst_str($sreg1, $false);
	setvalue_str($preg1, $sreg1);
	FreeSreg($sreg1);
	FreePreg($preg1);
    } elsif ($opc eq 'INT') {
	$y = shift @i;
	$x = shift @i;
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, 'str', $false);
	$sreg2 = AllocSreg();
	getvalue_str($sreg2, $preg2);
	$ireg1 = AllocIreg();
	cvt_str_int($ireg1, $sreg2, $false);
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'int', $false);
	setvalue_int($preg1, $ireg1);
	FreeIreg($ireg1);
	FreeSreg($sreg2);
	FreePreg($preg1);
	FreePreg($preg2);
    } elsif ($opc eq 'STR') {
	$y = shift @i;
	$x = shift @i;
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, 'int', $false);
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'str', $false);
	$ireg1 = AllocIreg();
	getvalue_int($ireg1, $preg2);
	$sreg1 = AllocSreg();
	cvt_int_str($sreg1, $ireg1, $false);
	setvalue_str($preg1, $sreg1);
	FreeSreg($sreg1);
	FreeIreg($ireg1);
	FreePreg($preg1);
	FreePreg($preg2);
    } elsif ($opc eq 'APPEND') {
	$x = shift @i;
	$v = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, 'str', $false);
	$sreg1 = AllocSreg();
	getvalue_str($sreg1, $preg1);
	$v = PrintValue('str', $v);
	append_strv($sreg1, $v, $false);
	setvalue_str($preg1, $sreg1);
	FreeSreg($sreg1);
	FreePreg($preg1);
    } elsif ($opc eq 'APPENDVAR') {
	$x = shift @i;
	$y = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, 'str', $false);
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, 'str', $false);
	$sreg1 = AllocSreg();
	getvalue_str($sreg1, $preg1);
	$sreg2 = AllocSreg();
	getvalue_str($sreg2, $preg2);
	append_str($sreg1, $sreg2, $false);
	setvalue_str($preg1, $sreg1);
	FreeSreg($sreg2);
	FreeSreg($sreg1);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'READ') {
	$x = shift @i;
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, 'str', $false);
	$sreg1 = AllocSreg();
	read_str($sreg1, $false);
	setvalue_str($preg1, $sreg1);
	FreeSreg($sreg1);
	if (IsFocusName($x)) {
	    setfocus($x, $preg1);
	}
	FreePreg($preg1);
    } elsif ($opc eq 'WRITE') {
	$x = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, 'str', $false);
	$sreg1 = AllocSreg();
	getvalue_str($sreg1, $preg1);
	FreePreg($preg1);
	write_str($sreg1, $false);
	FreeSreg($sreg1);
    } elsif ($opc eq 'WRITESTR') {
	$v = shift @i;
	$v = PrintValue('str', $v);
	write_strv($v, $false);
    } else {
	unshift @i, $opc;
	$self->SUPER::CG($false, @i);
    }
}

1;
