
package MSPio;

$VERSION = "0.01";

use Global;
use MSP;

require Exporter;
@ISA = qw( MSP  Exporter );
@EXPORT = @MSP::EXPORT;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
        die "module BI_TB not found\n";
    }
    unshift @ISA, qw( BI_TB );
} else {
    if (! eval {require "MSPiocore.pm"}) {
        die "module MSPiocore not found\n";
    }
    unshift @ISA, qw( MSPiocore );
}

$id = '[a-zA-Z][a-zA-Z0-9]*';
$object = '[a-zA-Z][a-zA-Z0-9\.]*';

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^read\s+($object)$/) {
	@prim = ( 'READ', $1 );
    } elsif ($i =~ /^write\s+($object)$/) {
	@prim = ( 'WRITE', $1 );
    } elsif ($i =~ /^write\s+($value{str})$/) {
	@prim = ( 'WRITESTR', ProperValue($1) );
    } else {
        @prim = $self->SUPER::Parse($i);
    }
#    print "prim: " . join("*", @prim) . "\n";
    return @prim
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'READ') {
	$x = shift @i;
	return "read $x";
    } elsif ($opc eq 'WRITE') {
	$x = shift @i;
	return "write $x";
    } elsif ($opc eq 'WRITE') {
	$x = shift @i;
	return "write \"$x\"";
    } elsif ($opc eq 'WRITESTR') {
	$x = shift @i;
	$x = PrintValue('str', $x);
	return "write $x";
    } else {
	return $self->SUPER::Print($opc, @i);
    }
}

1;
