
package MSPfuncparse;

$VERSION = "0.00";

use Global;
use MSPea;
@ISA = qw(MSPea);

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^function\s+($object)\(\s*($id(:($types))?(\s*,\s*$id(:($types))?)*)?\s*\)(:($types))?\s+($value{str})$/) {
	@prim = ( 'FUNCTION', $1);
	$t = $9;
	$d = $10;
	$_ = $2;
	@ma = /($id(?::(?:$types))?)(?:\s*,\s*|$)/g;
	push @prim, @ma;
	push @prim, ($t, $d);
    } elsif ($i =~ /^($id)\(\s*(($object|$value{any})(\s*,\s*($object|$value{any}))*)?\s*\)$/) {
	@prim = ( 'CALL', $1 );
	$_ = $2;
#	@ma = /^($object|$value{any})(?:\s*,\s*($object|$value{any}))*$/;
	@ma = /($object|$value{any})(?:\s*,\s*|$)/g;
	push @prim, @ma;
# print STDERR "*** ", join(" - ", @ma), " ***\n";
    } elsif ($i =~ /^($object)\s*=\s*($id)\(\s*(($object|$value{any})(\s*,\s*($object|$value{any}))*)?\s*\)$/) {
	@prim = ( 'CALLR', $1, $2 );
	$_ = $3;
	@ma = /($object|$value{any})(?:\s*,\s*|$)/g;
	push @prim, @ma;
    } elsif ($i =~ /^return ($object|$value{any})$/) {
	@prim = ( 'FUNCRETURN', $1);
    } else {
        @prim = $self->SUPER::Parse($i);
    }
#    print STDERR "prim: " . join("*", @prim) . "\n";
    return @prim
}

1;
