
package MSPfunccore;

$VERSION = "0.06";

use Global;
use MSPfuncparse;
use MSPeacore;
use MSPcore;
use FluidValues;
use FluidObjects;
our @ISA = qw( MSPfuncparse MSPeacore MSPcore FluidValues FluidObjects);

sub AddBasic {
    my $self = shift;
    my $h = shift;
    my $b = shift;
    my @i;

    FluidObjects->set_intern();
    @i = $self->Parse($b);
    if ($i[0] eq 'CALL') {
	AddField($h, 'basic');
	SetFieldNew($h, 'basic');
	$h = GetField($h, 'basic');
	SetFieldNew($h, 'call');
	$h = GetField($h, 'call');
	AddValueField($h, 'func', 'str', $i[1]);
	AddValueField($h, 'args', 'str', join(',', @i[2 .. $#i]));
    } elsif ($i[0] eq 'CALLR') {
	AddField($h, 'basic');
	SetFieldNew($h, 'basic');
	$h = GetField($h, 'basic');
	SetFieldNew($h, 'call');
	$h = GetField($h, 'call');
	AddValueField($h, 'func', 'str', $i[2]);
	AddValueField($h, 'ret', 'str', $i[1]);
	AddValueField($h, 'args', 'str', join(',', @i[3 .. $#i]));
    } elsif ($i[0] eq 'FUNCRETURN') {
	AddField($h, 'basic');
	SetFieldNew($h, 'basic');
	$h = GetField($h, 'basic');
	AddValueField($h, 'return', 'str', $i[1]);
    } else {
	$self->SUPER::AddBasic($h, $b);
    }
    FluidObjects->reset();
}

sub findfield {
    my $h = shift;
    my $f = shift;

    while ($h != 0) {
	if (HasField($h, $f)) {
	    return $h;
	}
	$h = GetField($h, 'next');
    }
    return 0;
}

sub findlabel {
    my $h = shift;
    my $v = shift;

    while ($h != 0) {
	if (HasField($h, 'label')) {
	    if ($v == GetValue(GetField($h, 'label'))) {
		return $h;
	    }
	}
	$h = GetField($h, 'next');
    }
    return 0;
}

sub compile_program {
    my $self = shift;
    my $s = shift;
    my @il;
    my $i;
    my $ps;
    my $pp;
    my $h;
    my $errors;
    
    @il = $self->str2list($s);
    $ps = SetFocus('_Ps', 0);
    $pp = SetFocus('_Pp', $ps);
    $errors = 0;
    while ($i = shift @il) {
	$h = NewFocus('_Ph');
	if ($ps == 0) {
	    $ps = SetFocus('_Ps', $h);
	    $pp = SetFocus('_Pp', $h);
	} else {
	    SetField($pp, 'next', $h);
	}
	if ($i =~ /^!$/) {
	    AddField($h, 'end');
	} elsif ($i =~ /^L(\d+)$/) {
	    AddValueField($h, 'label', 'int', $1);
	} elsif ($i =~ /^##L(\d+)$/) {
	    AddValueField($h, 'goto', 'int', $1);
	} elsif ($i =~ /^\}\{$/) {
	    AddField($h, 'else');
	} elsif ($i =~ /^\}$/) {
	    AddField($h, 'endif');
	} elsif ($i =~ /^\+(.+)\{$/) {
	    AddField($h, 'ift');
	    $self->AddBasic($h, $1);
	} elsif ($i =~ /^\-(.+)\{$/) {
	    AddField($h, 'iff');
	    $self->AddBasic($h, $1);
	} elsif ($i =~ /^\+(.+)$/) {
	    AddField($h, 'testt');
	    $self->AddBasic($h, $1);
	} elsif ($i =~ /^\-(.+)$/) {
	    AddField($h, 'testf');
	    $self->AddBasic($h, $1);
	} elsif ($i =~ /^return /) {
	    AddField($h, 'return');
	    $self->AddBasic($h, $i);
	} else {
	    $self->AddBasic($h, $i);
	}
	$pp = SetFocus('_Pp', $h);
    }
    SetField($pp, 'next', 'null');
    for ($h = $ps; $h != 0; $h = GetField($h, 'next')) {
	if (HasField($h, 'ift')) {
	    SetField($h, 'T', GetField($h, 'next'));
	    $f = findfield($h, 'else');
	    if ($f == 0) {
		$f = findfield($h, 'endif');
	    }
	    SetField($h, 'F', GetField($f, 'next'));
	    AddField($h, 'test');
	    DelField($h, 'ift');
	} elsif (HasField($h, 'iff')) {
	    SetField($h, 'F', GetField($h, 'next'));
	    $f = findfield($h, 'else');
	    if ($f == 0) {
		$f = findfield($h, 'endif');
	    }
	    SetField($h, 'T', GetField($f, 'next'));
	    AddField($h, 'test');
	    DelField($h, 'iff');
	} elsif (HasField($h, 'else')) {
	    $f = findfield($h, 'endif');
	    SetField($h, 'goto', GetField($f, 'next'));
	    DelField($h, 'else');
	} elsif (HasField($h, 'endif')) {
	    SetField($h, 'goto', GetField($h, 'next'));
	    DelField($h, 'endif');
	} elsif (HasField($h, 'testt')) {
	    $f = GetField($h, 'next');
	    SetField($h, 'T', $f);
	    if ($f != 0) {
		$f = GetField($f, 'next');
	    }
	    SetField($h, 'F', $f);
	    AddField($h, 'test');
	    DelField($h, 'testt');
	} elsif (HasField($h, 'testf')) {
	    $f = GetField($h, 'next');
	    SetField($h, 'F', $f);
	    if ($f != 0) {
		$f = GetField($f, 'next');
	    }
	    SetField($h, 'T', $f);
	    AddField($h, 'test');
	    DelField($h, 'testf');
	} elsif (HasField($h, 'goto')) {
	    $v = GetValue(GetField($h, 'goto'));
	    $f = findlabel($ps, $v);
	    DelField($h, 'goto');
	    SetField($h, 'goto', GetField($f, 'next'));
	}
    }
    for ($h = $ps; $h != 0; $h = GetField($h, 'next')) {
	if (HasField($h, 'label')) {
	    DelField($h, 'label');
	    SetField($h, 'goto', GetField($h, 'next'));
	} elsif (HasField($h, 'return')) {
	    DelField($h, 'return');
	    $pp = NewFocus('_Ph');
	    SetField($pp, 'next', GetField($h, 'next'));
	    SetField($h, 'next', $pp);
	    AddField($pp, 'end');
	}
    }

    SetFocus('_Ph', 0);
    SetFocus('_Pp', 0);

    return ($ps, $errors);
}

sub coreEvalBasic {
    my $self = shift;
    my $env = shift;
    my $b = shift;
    my @i;
    my $j;
    my $r;
    my $sb;


    FluidObjects->set_intern();
    $sb = GetValue($b);
    $sb =~ s/\<\>/$env/g;
    @i = $self->parse_basic($sb);
    FluidObjects->reset();
    if ($i[0] eq 'ERROR') {
        return -1;
    }
    if ($trace) {
        $class = ref($self) || $self;
        $s = $class->Print(@i);
        print "$s";
    }
if ($i[0] eq 'APPLY') {
    $r = $self->Exec('APPLY', $env, $i[1]);
    return $r;
}
    if (($i[0] eq 'EVAL') || ($i[0] eq 'APPLY')) {
        return 0;
    }
if ($i[0] eq 'EVAL') { $evallevel ++;}
if ($i[0] eq 'EVAL' && $trace) { print "\n";}
    $r = $self->Exec(@i);
if ($i[0] eq 'EVAL') { $evallevel --;}
    return $r;
}

sub do_compile {
    my $self = shift;
    my $f = shift;
    my $v = shift;
    my $p;
    my $errors;

    ($p, $errors) = $self->compile_program($v);
    SetFocus($f, $p);
    SetFocus('_Ps', 0);
    if ($errors) {
	return 0;
    } else {
	return 1;
    }
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $f;
    my $p;
    my $par;
    my $fp;
    my $h;
    my $r;
    my $s;
    my $t;
    my @p;
    my $env;
    my $field;
    my $tfield;
    my $val;
    my $tval;

    $opc = shift @i;
    if ($opc eq 'ADDTYPEPAR') {
	$f = shift @i;
	$t = shift @i;
	$p = join(',', @i);
	$r = $self->Exec('NEWVALFIELDVALASSIGN', $f, 'par', 'str', $p);
	$r = $self->Exec('NEWVALFIELDVALASSIGN', $f, 'type', 'str', $t);
#	$r = $self->Exec('NEWFIELDASSIGN', $f, 'par', 'new');
#	$i = 0;
#	foreach $p (@i) {
#	    $i ++;
#	    $self->Exec('NEWVALFIELDVALASSIGN', "$f.par", "p$i", 'str', $p);
#	}
    } elsif ($opc eq 'BINDPAR') {
	$env = shift @i;
	$f = shift @i;
	$fp = GetFocus($f);
	$par = GetField($fp, 'par');
	$par = GetValue($par);
	@p = split(',', $par);
	if ($#p != $#i) {
	    return 0;
	}
	for ($j = 0; $j <= $#i; $j ++) {
	    if ($p[$j] =~ /^(.+):(.+)$/) {
		$field = $1;
		$tfield = $2;
		if ($i[$j] =~ /^($value{any})$/) {
		    $val = $1;
		    $tval = ValueType($val);
		    $val = ProperValue($val);
		    if ($tval ne $tfield) {
			return 0;
		    }
		    $r = $self->Exec('NEWVALFIELDVALASSIGN', $env, $field, $tfield, $val);
		} else {
		    $r = $self->Exec('NEWVALFIELDASSIGN', $env, $field, $tfield, $i[$j]);
		}
	    } else {
		$r = $self->Exec('NEWFIELDASSIGN', $env, $p[$j], $i[$j]);
	    }
	    if (! $r) {
		return 0;
	    }
	}
	$t = GetField($fp, 'type');
	$t = GetValue($t);
	if ($t eq '') {
	    $self->Exec('NEWFIELDASSIGN', $env, 'return', 'null');
	} else {
	    $self->Exec('NEWVALFIELD', $env, 'return', $t);
	}
	return 1;
    } elsif ($opc eq 'BINDPARSTR') {
	$env = shift @i;
	$f = shift @i;
	$a = shift @i;
	$fp = GetFocus($f);
	$par = GetField($fp, 'par');
	$par = GetValue($par);
	@p = split(',', $par);
	($h, $hv) = ExtendedFocus($a);
	$h = GetField($h, $hv);
	$h = GetValue($h);
	$h =~ s/\<\>/${env}.prev/g;
	@args = split(',', $h);
	if ($#p != $#args) {
	    return 0;
	}
	for ($j = 0; $j <= $#args; $j ++) {
	    if ($p[$j] =~ /^(.+):(.+)$/) {
		$field = $1;
		$tfield = $2;
		if ($args[$j] =~ /^($value{any})$/) {
		    $val = $1;
		    $tval = ValueType($val);
		    $val = ProperValue($val);
		    if ($tval ne $tfield) {
			return 0;
		    }
		    $r = $self->Exec('NEWVALFIELDVALASSIGN', $env, $field, $tfield, $val);
		} else {
		    $r = $self->Exec('NEWVALFIELDASSIGN', $env, $field, $tfield, $args[$j]);
		}
	    } else {
		$r = $self->Exec('NEWFIELDASSIGN', $env, $p[$j], $args[$j]);
	    }
	    if (! $r) {
		return 0;
	    }
	}
	$t = GetField($fp, 'type');
	$t = GetValue($t);
	if ($t eq '') {
	    $self->Exec('NEWFIELDASSIGN', $env, 'return', 'null');
	} else {
	    $self->Exec('NEWVALFIELD', $env, 'return', $t);
	}
	return 1;
    } elsif ($opc eq 'SETFUNCRETURN') {
	$env = shift @i;
	$r = shift @i;
	($h, $hv) = ExtendedFocus($r);
	$h = GetField($h, $hv);
	$h = GetValue($h);
	if ($h =~ /^($value{any})$/) {
            $val = $1;
            $tval = ValueType($val);
            $val = ProperValue($val);
            $r = $self->Exec('VALASSIGN', "${env}.return", $val, $tval);
        } else {
            $h =~ s/\<\>/$env/g;
            $r = $self->Exec('ASSIGN', "${env}.return", $h);
        }
	return $r;
    } elsif ($opc eq 'GETFUNCRETURN') {
	$env = shift @i;
	$r = shift @i;
	($h, $hv) = ExtendedFocus($r);
	$h = GetField($h, $hv);
	$h = GetValue($h);
	$h =~ s/\<\>/${env}.prev/g;
	$r = $self->Exec('ASSIGN', $h, "${env}.return");
	return $r;
    } elsif ($opc eq 'COMPILE-PGLEc') {
	$f = shift @i;
	$s = shift @i;
	$r = $self->do_compile($f, $s);
	return $r;
    } else {
	unshift @i, $opc;
	return $self->SUPER::Exec(@i);
    }
}

1;
