
package MSPeacore;

$VERSION = "2.04";

use Global;
use MSPeaparse;
use MSPcore;
our @ISA = qw( MSPeaparse MSPcore );

### Evaluation complex ###

sub str2list {
    my $self = shift;
    my $s = shift;
    my @il;
    my $i;

    @il = ();
#    $s =~ /^\"\s*(.*)\s*\"$/;
#    $s = $1;
    while ($s =~ /^([^\";]*(\"([^\"\\]|\\\\|\\\")*\")?)*;/) {
	$i = $&;
	$s = $';
	chop $i;
	if ($i =~ /^\s*(.*\S)\s*$/) {
	    $i = $1;
	}
	push @il, $i;
    }
    if ($s =~ /^\s*(.*\S)\s*$/) {
	$s = $1;
    }
    push @il, $s;
    return @il;
}

sub parse_basic {
    my $self = shift;
    my $i = shift;
    my $class;
    my @i;

#    $class = ref($self) || $self; # otherwise use MSP
#    @i = $class->Parse($i);
    @i = $self->Parse($i);
    return @i;
}

sub AddBasic {
    my $self = shift;
    my $h = shift;
    my $b = shift;
    my @i;

    @i = $self->Parse($b);
    if ($i[0] eq 'EVAL') {
	AddField($h, 'basic');
	SetFieldNew($h, 'basic');
	$h = GetField($h, 'basic');
	AddValueField($h, 'eval', 'str', $i[1]);
    } else {
	AddValueField($h, "basic", 'str', $b);
    }
}

sub compile_program_pgla {
    my $self = shift;
    my $s = shift;
    my @il;
    my $i;
    my $end;
    my $ic;
    my $b;

    @il = $self->str2list($s);

    $ps = SetFocus("_Ps", 0);
    $pp = SetFocus("_Pp", $ps);
    $end = 0;
    $ic = 0;
    $errors = 0;
    while (($i = shift @il) && ! $end) {
	$h = NewFocus("_Ph");
	if ($ps == 0) {
	    $ps = SetFocus("_Ps", $h);
	    $pp = SetFocus("_Pp", $h);
	} else {
	    SetField($pp, "next", $h);
	}
	if ($i =~ /^!$/) {
	    AddField($h, "end");
	} elsif ($i =~ /^#(\d+)$/) {
	    AddValueField($h, "goto", 'int', $1);
	} elsif ($i =~ /^\+\s*(.+)$/) {
	    AddField($h, "testt");
#	    AddValueField($h, "basic", 'str', $1);
	    $self->AddBasic($h, $1);
	} elsif ($i =~ /^-\s*(.+)$/) {
	    AddField($h, "testf");
#	    AddValueField($h, "basic", 'str', $1);
	    $self->AddBasic($h, $1);
	} elsif ($i =~ /^\\\\#(\d+)$/) {
	    $repeat = $1;
	    AddValueField($h, "repeat", 'int', $repeat);
	    $end = 1;
	    if ($repeat <= $ic) {
		my $n;
		my $j;

		$n = $ps;
		for ($j = $ic - $repeat; $j > 0; $j --) {
		    $n = GetField($n, 'next');
		}
		SetField($h, "next", $n);
	    } else {
		my $n;
		my $nh;

		$n = $ps;
		for ($j = $repeat - $ic; $j > 0; $j --) {
		    $nh = NewFocus("_Pnh");
		    SetField($nh, "next", $n);
		    SetField($nh, "goto", $nh);
		    $n = $nh;
		}
		SetField($h, "next", $n);
		SetFocus("_Pnh", 0);
	    }
	} else {
#	    AddValueField($h, "basic", 'str', $i);
	    $self->AddBasic($h, $i);
	}
	$pp = SetFocus("_Pp", $h);
	$ic ++;
    }
    if (! $end) {
	SetField($pp, "next", "null");
    }
    SetFocus("_Pp", 0);
    SetFocus("_Pb", 0);
    
    for ($h = $ps; $h != 0; $h = GetField($h, 'next')) {
	if (HasField($h, 'repeat')) {
	    SetField($h, "goto", GetField($h, 'next'));
	    SetField($h, "next", "null");
	    DelValueField($h, "repeat");
	    last;
	} elsif (HasField($h, 'goto')) {
	    my $n;
	    my $j;

	    $n = $h;
	    for ($j = GetValue(GetField($h, 'goto')); $j > 0; $j --) {
		$n = GetField($n, 'next');
		if (HasField($n, 'repeat')) {
		    $n = GetField($n, 'next');
		}
		if ($n == 0) {
		    last;
		}
	    }
	    DelValueField($h, "goto");
	    SetField($h, "goto", $n);
	} elsif (HasField($h, 'testt')) {
	    my $n = GetField($h, 'next');

	    SetField($h, "T", $n);
	    if ($n == 0) {
		SetField($h, "F", $n);
	    } else {
		SetField($h, "F", GetField($n, 'next'));
	    }
	    DelField($h, "testt");
	    AddField($h, "test");
	} elsif (HasField($h, 'testf')) {
	    my $n = GetField($h, 'next');

	    SetField($h, "F", $n);
	    if ($n == 0) {
		SetField($h, "T", $n);
	    } else {
		SetField($h, "T", GetField($n, 'next'));
	    }
	    DelField($h, "testf");
	    AddField($h, "test");
	}
    }
    SetFocus("_Ph", 0);
    return ($ps, $errors);
}

my $trace = 0;
my $evallevel = 0;

sub coreEvalBasic {
    my $self = shift;
    my $env = shift;
    my $b = shift;
    my @i;
    my $j;
    my $r;
    my $sb;

    $sb = GetValue($b);
    @i = $self->parse_basic($sb);
    if ($i[0] eq 'ERROR') {
        return -1;
    }
    if ($trace) {
        $class = ref($self) || $self;
        $s = $class->Print(@i);
        print "$s";
    }
    if (($i[0] eq 'EVAL') || ($i[0] eq 'APPLY')) {
        return 0;
    }
if ($i[0] eq 'EVAL') { $evallevel ++;}
if ($i[0] eq 'EVAL' && $trace) { print "\n";}
    $r = $self->Exec(@i);
if ($i[0] eq 'EVAL') { $evallevel --;}
    return $r;
}

sub do_compile_pgla {
    my $self = shift;
    my $x = shift;
    my $a;

    if (IsFocusName($x)) {
	if (! ($a = GetFocus($x))) {
	    return 0;
	}
    } else {
	($ax, $fx) = ExtendedFocus($x);
	if ($ax == -1) {
	    return 0;
	}
	$a = GetField($ax, $fx);
    }
    if (! IsType($a, 'str')) {
	return 0;
    }
    $v = GetValue($a);
    ($p, $errors) = $self->compile_program_pgla($v);
    if (IsFocusName($x)) {
	SetFocus($x, $p);
    } else {
	DelValueField($ax, $fx);
	SetField($ax, $fx, $p);
    }
    SetFocus("_Ps", 0);
    if ($errors) {
	return 0;
    } else {
	return 1;
    }
}

sub do_apply {
    my $self = shift;
    my $env = shift;
    my $x = shift;
    my $a;

    if ($a = ExtendedFocusTypedValue($x, 'str')) {
	$r = $self->coreEvalBasic($env, $a);
	if ($r == -1) {return 0}
	return $r;
    } else {
	return 0;
    }
}

### end (Evaluation complex) ###

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;
    my $t;
    my $h;
    my $n;
    my $pc;
    my $stack;
    my $item;

    $opc = shift @i;
    if ($opc eq 'EVAL'){
	$x = shift @i;
	#$r = $self->do_eval($x);
	#return $r;
	print STDERR "ERROR: eval in MSPeacore\n";
	return 0;
    } elsif ($opc eq 'COMPILE'){
	$x = shift @i;
	$r = $self->do_compile_pgla($x);
	return $r;
    } elsif ($opc eq 'APPLY'){
	$env = shift @i;
	$x = shift @i;
	$r = $self->do_apply($env, $x);
	return $r;
    } elsif ($opc eq 'SETREF'){ # added for eval as primitive
	$x = shift @i;
	$y = shift @i;
	($h, $f) = ExtendedFocus($y);
	$h = GetField($h, $f);
	$h = GetValue($h);
	if (IsFocusName($h)) {
	    if (! ($h = GetFocus($h))) {
		$h = 0;
	    }
	} else {
	    ($h, $f) = ExtendedFocus($h);
	    if ($h == -1) {
		$h = 0;
	    } else {
		$h = GetField($h, $f);
	    }
	}
	SetFocus($x, $h);
	return 1;
    } elsif ($opc eq 'PUSH'){ # added for eval as primitive
	$stack = shift @i;
	$item = shift @i;
	$h = NewFocus('_Ph');
	$n = GetFocus("$stack");
	$x = GetFocus("$item");
	SetField($h, 'prev', $n);
	SetField($h, 'item', $x);
	SetFocus("$stack", $h);
	RemoveFocus('_Ph');
	return 1;
    } elsif ($opc eq 'POP'){ # added for eval as primitive
	$stack = shift @i;
	$item = shift @i;
	$h = GetFocus("$stack");
	SetFocus('_Ph', $h);
	$x = GetField($h, 'item');
	SetFocus("$item", $x);
	$n = GetField($h, 'prev');
	SetFocus("$stack", $n);
	RemoveAtom('_Ph');
	return 1;
    } else {
	unshift @i, $opc;
	return $self->MSPcore::Exec(@i);
    }
}

1;
