
package MSPea;

$VERSION = "2.07";

use Global;
use MSPeaparse;
use MSP;
use Exporter;
@ISA = qw( MSPeaparse MSP Exporter);
@EXPORT = @MSP::EXPORT;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
        die "module BI_TB not found\n";
    }
    unshift @ISA, qw( BI_TB );
} else {
    if (! eval {require "MSPeacore.pm"}) {
        die "module MSPeacore not found\n";
    }
    unshift @ISA, qw( MSPeacore );
}

if (defined $::id) {
    $ID = $::id;
} else {
    $ID = '';
}
my $mypc = "_pc${ID}";
my $mystack = "_P${ID}stack";

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;
    my $env;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'EVAL') {
	$x = shift @i;
	return "eval $x";
    } elsif ($opc eq 'COMPILE') {
	$x = shift @i;
	return "compile $x";
    } elsif ($opc eq 'APPLY') {
	$env = shift @i;
	$x = shift @i;
	return "apply $x";
    } elsif ($opc eq 'SETREF') {
	$x = shift @i;
	$y = shift @i;
	return "seteval $x $y";
    } elsif ($opc eq 'PUSH') {
	$x = shift @i;
	return "pushpc $x";
    } elsif ($opc eq 'POP') {
	$x = shift @i;
	return "poppc $x";
    } else {
	return $self->SUPER::Print($opc, @i);
    }
}

$evalstop = 0;

sub evalstop {
    return $evalstop;
}

sub EvalBasic {
    my $self = shift;
    my $b;
    my @i;
    my $r;

    if ($self->Exec('MEMBER', "$mypc.basic", 'eval')) {
	$self->Exec('SETREF', "_P${ID}eval", "$mypc.basic.eval");
	$self->Exec('PUSH', "$mystack", "$mypc");
	$r = $self->do_eval("_P${ID}eval");
	if ($evalstop) {
	    return $r;
	}
	$self->Exec('POP', "$mystack", "$mypc");
	$self->Exec('ASSIGN', "_P${ID}eval", 'null');
	return $r;
    } else {
	return $self->Exec('APPLY', $mystack, "$mypc.basic");
    }
}

sub EvalProgram {
    my $self = shift;
    my $pc = shift;
    my $r;
    my $b;

    $self->Exec('ASSIGN', "$mypc", $pc);
    $r = 1;
    if (! $::kernel->NextStep) {
	$self->Exec('ASSIGN', "$mypc", 'null');
	return $r;
    }
    $evalstop = 0;
    while (! $self->Exec('EQUAL', "$mypc", 'null')) {
	if ($self->Exec('MEMBER', "$mypc", 'goto')) {
	    $self->Exec('ASSIGN', "$mypc", "$mypc.goto");
	    if ($::kernel->Trace()) {
		$::ui->Msg("func: goto\n");
	    }
	} elsif ($self->Exec('MEMBER', "$mypc", 'end')) {
	    if ($::kernel->Trace()) {
		$::ui->Msg("func: end\n");
	    }
	    last;
	} elsif ($self->Exec('MEMBER', "$mypc", 'test')) {
	    if ($::kernel->Trace()) {
		$::ui->Msg("func: test\n");
	    }
	    $r = $self->EvalBasic();
	    if ($evalstop) {
		return $r;
	    }
	    if ($::kernel->Trace()) {
		$::ui->Msg("        => " . ($r ? "T" : "F") . "\n");
	    }
	    if ($r) {
		$self->Exec('ASSIGN', "$mypc", "$mypc.T");
	    } else {
		$self->Exec('ASSIGN', "$mypc", "$mypc.F");
	    }
	} else {
	    if ($::kernel->Trace()) {
		$::ui->Msg("func: basic\n");
	    }
	    $r = $self->EvalBasic();
	    if ($evalstop) {
		return $r;
	    }
	    if ($::kernel->Trace()) {
		$::ui->Msg("        => " . ($r ? "T" : "F") . "\n");
	    }
	    $self->Exec('ASSIGN', "$mypc", "$mypc.next");
	}
	if (! $::kernel->NextStep) {
	    $evalstop = 1;
	    last;
	}
    }
    $self->Exec('ASSIGN', "$mypc", 'null');
    return $r;
}

sub do_eval {
    my $self = shift;
    my $x = shift;

    if ($self->Exec('TYPEFIELD', $x, 'NONE')) {
	return $self->EvalProgram($x);
# use compile instead of eval
#    } elsif ($self->Exec('TYPEFIELD', $x, 'str')) {
#	return $self->Exec('COMPILE', $x);
#       should be followed by an eval!
    } else {
	return 0;
    }
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;

    $opc = shift @i;
    if ($opc eq 'EVAL') {
	$x = shift @i;
	return $self->do_eval($x);
    } else {
	unshift @i, $opc;
	return $self->SUPER::Exec(@i);
    }
}
1;
