
package MSPcore;

$VERSION = "1.02";

use Global;
use HMPPVcore;

require Exporter;
@ISA = qw( HMPPVcore Exporter );
@EXPORT = @HMPPVcore::EXPORT;

sub strsubst {
    my $s = shift;
    my $v = "";
    my $c;
    my $r;
    my $match;
    my $var;
    my $pvalue;

    while ($s ne "") {
	if ($s =~ /(\\|\$)/) {
	    $v .= $`;
	    $c = $&;
	    $r = $';
	    $s = "$&$'";
	    if ($s =~ /^\\(.)/) {
		$v .= "$`$1";
		$s = $';
	    } elsif ($s =~ /^\$\{([a-zA-Z][a-zA-Z0-9\.]*)\}/) {
		$v .= $`;
		$match = $&;
		$var = $1;
		$s = $';
		if (defined ($pvalue = ExtendedFocusValue($var))) {
		    if (! IsType($pvalue, 'NONE')) {
			$v .= GetValue($pvalue);
		    }
		    # else add the empty string
		}
		# else add the empty string
	    } else {
		$v .= $c;
		$s = $r;
	    }
	} else {
	    $v .= $s;
	    last;
	}
    }
    return $v;
}

sub strescape {
    my $s = shift;
    my $v = "";

    $s =~ s/(\\|\"|\$)/\\$1/g;
    return $s;
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;
    my $t;

#print STDERR "MSPcore: ", join("-", @i), "\n";
    $opc = shift @i;
    if ($opc eq 'SUBST'){
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'str')) {
	    $v = strsubst(GetValue($a));
	    return AssignValue($x, $v, 'str');
	} else {
	    return 0;
	}
    } elsif ($opc eq 'ESCAPE'){
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'str')) {
	    $v = strescape(GetValue($a));
	    return AssignValue($x, $v, 'str');
	} else {
	    return 0;
	}
    } elsif ($opc eq 'INCR'){
	$x = shift @i;
	$v = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'int')) {
	    return AssignValue($x, GetValue($a) + $v, 'int');
	} else {
	    return 0;
	}
    } elsif ($opc eq 'INCRVAR'){
	$x = shift @i;
	$y = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'int')) {
	    if ($ay = ExtendedFocusTypedValue($y, 'int')) {
		return AssignValue($x, GetValue($a) + GetValue($ay), 'int');
	    }
	}
	return 0;
    } elsif ($opc eq 'DECR'){
	$x = shift @i;
	$v = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'int')) {
	    if (GetValue($a) >= $v) {
		return AssignValue($x, GetValue($a) - $v, 'int');
	    }
	}
	return 0;
    } elsif ($opc eq 'DECRVAR'){
	$x = shift @i;
	$y = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'int')) {
	    if ($ay = ExtendedFocusTypedValue($y, 'int')) {
		if (GetValue($a) >= GetValue($ay)) {
		    return AssignValue($x, GetValue($a) - GetValue($ay), 'int');
		}
	    }
	}
	return 0;
    } elsif ($opc eq 'FIRST'){
	$y = shift @i;
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($y, 'str')) {
	    $v = GetValue($a);
	    if ($v eq "") {
		return 0;
	    }
	    if (length $v > 1) {
		$v = substr $v, 0, 1;
	    }
	    return AssignValue($x, $v, 'str');
	}
	return 0;
    } elsif ($opc eq 'DELFIRST'){
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'str')) {
	    $v = GetValue($a);
	    if ($v eq "") {
		return 0;
	    }
	    if (length $v > 1) {
		$v = substr $v, 1;
	    } else {
		$v = "";
	    }
	    return AssignValue($x, $v, 'str');
	}
	return 0;
    } elsif ($opc eq 'INT'){
	$y = shift @i;
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($y, 'str')) {
	    $v = GetValue($a);
	    if ($v =~ /^(([1-9]\d*)?\d)$/) {
		$v = $1;
		return AssignValue($x, $v, 'int');
	    } else {
		return 0;
	    }
	}
	return 0;
    } elsif ($opc eq 'STR'){
	$y = shift @i;
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($y, 'int')) {
	    return AssignValue($x, GetValue($a), 'str');
	}
	return 0;
    } elsif ($opc eq 'APPEND'){
	$x = shift @i;
	$v = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'str')) {
	    return AssignValue($x, GetValue($a) . "$v", 'str');
	}
	return 0;
    } elsif ($opc eq 'APPENDVAR'){
	$x = shift @i;
	$y = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if ($a = ExtendedFocusTypedValue($x, 'str')) {
	    if ($ay = ExtendedFocusTypedValue($y, 'str')) {
		return AssignValue($x, GetValue($a) . GetValue($ay), 'str');
	    }
	}
	return 0;
    } else {
	unshift @i, $opc;
	return $self->SUPER::Exec(@i);
    }
}

1;
