
package MSP;

$VERSION = "1.02";

use Global;
use HMPPV;

require Exporter;
@ISA = qw( HMPPV Exporter );
@EXPORT = @HMPPV::EXPORT;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
        die "module BI_TB not found\n";
    }
    unshift @ISA, qw( BI_TB );
} else {
    if (! eval {require "MSPcore.pm"}) {
        die "module MSPcore not found\n";
    }
    unshift @ISA, qw( MSPcore );
}

#$id = '[a-zA-Z][a-zA-Z0-9]*';
#$object = '[a-zA-Z][a-zA-Z0-9\.]*';

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^subst\s+($object)$/) {
	@prim = ( 'SUBST', $1 );
    } elsif ($i =~ /^escape\s+($object)$/) {
	@prim = ( 'ESCAPE', $1 );
    } elsif ($i =~ /^incr\s+($object)$/) {
	@prim = ( 'INCR', $1, 1 );
    } elsif ($i =~ /^incr\s+($object)\s+($value{int})$/) {
	@prim = ( 'INCR', $1, $2 );
    } elsif ($i =~ /^incr\s+($object)\s+($object)$/) {
	@prim = ( 'INCRVAR', $1, $2 );
    } elsif ($i =~ /^decr\s+($object)$/) {
	@prim = ( 'DECR', $1, 1 );
    } elsif ($i =~ /^decr\s+($object)\s+($value{int})$/) {
	@prim = ( 'DECR', $1, $2 );
    } elsif ($i =~ /^decr\s+($object)\s+($object)$/) {
	@prim = ( 'DECRVAR', $1, $2 );
    } elsif ($i =~ /^first\s+($object)\s+($object)$/) {
	@prim = ( 'FIRST', $1, $2 );
    } elsif ($i =~ /^delfirst\s+($object)$/) {
	@prim = ( 'DELFIRST', $1 );
    } elsif ($i =~ /^int\s+($object)\s+($object)$/) {
	@prim = ( 'INT', $1, $2 );
    } elsif ($i =~ /^str ($object)\s+($object)$/) {
	@prim = ( 'STR', $1, $2 );
    } elsif ($i =~ /^append\s+($object)\s+($value{str})$/) {
	$x = $1;
	$v = $2;
	$v = ProperValue($v);
	@prim = ( 'APPEND', $x, $v );
    } elsif ($i =~ /^append\s+($object)\s+($object)$/) {
	$x = $1;
	$y = $2;
	@prim = ( 'APPENDVAR', $x, $y );
    } else {
        @prim = $self->SUPER::Parse($i);
    }
#    print "prim: " . join("*", @prim) . "\n";
    return @prim
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'SUBST') {
	$x = shift @i;
	return "subst $x";
    } elsif ($opc eq 'ESCAPE') {
	$x = shift @i;
	return "escape $x";
    } elsif ($opc eq 'INCR') {
	$x = shift @i;
	$v = shift @i;
	if ($v == 1) {
	    return "incr $x";
	} else {
	    return "incr $x $v";
	}
    } elsif ($opc eq 'INCRVAR') {
	$x = shift @i;
	$y = shift @i;
	return "incr $x $y";
    } elsif ($opc eq 'DECR') {
	$x = shift @i;
	$v = shift @i;
	if ($v == 1) {
	    return "decr $x";
	} else {
	    return "decr $x $v";
	}
    } elsif ($opc eq 'DECRVAR') {
	$x = shift @i;
	$y = shift @i;
	return "decr $x $y";
    } elsif ($opc eq 'FIRST') {
	$x = shift @i;
	$y = shift @i;
	return "first $x $y";
    } elsif ($opc eq 'DELFIRST') {
	$x = shift @i;
	$y = shift @i;
	return "delfirst $x $y";
    } elsif ($opc eq 'INT') {
	$x = shift @i;
	$y = shift @i;
	return "int $x $y";
    } elsif ($opc eq 'STR') {
	$x = shift @i;
	$y = shift @i;
	return "str $x $y";
    } elsif ($opc eq 'APPEND') {
	$x = shift @i;
	$v = shift @i;
	$v = PrintValue('str', $v);
	return "append $x $v";
    } elsif ($opc eq 'APPENDVAR') {
	$x = shift @i;
	$y = shift @i;
	return "append $x $y";
    } else {
	return $self->SUPER::Print($opc, @i);
    }
}

1;
