
package MPPcore;

$VERSION = "0.04";

use Global;

@focus = ();
@atom = ();
$nratoms = 0;

sub focus_null {
    my $x = shift;

    if (defined $::nonull) {
	if (defined $focus{$x}) {
	    delete $focus{$x};
	    if (defined $::coreview) {
		print FLUID "remfocus($x)\n";
		$ack = <ACK>;
	    }
	}
    } else {
	$focus{$x} = $focus{null};
	if (defined $::coreview) {
	    print FLUID "setfocus($x, null)\n";
	    $ack = <ACK>;
	}
    }
}

sub is_null {
    my $x = shift;

    if ((! defined $focus{$x}) || $focus{$x} == $focus{null}) {
	return 1;
    } else {
	return 0;
    }
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;

    $opc = shift @i;
    if ($opc eq 'NEWATOM') {
	$x = shift @i;
	if ($x eq 'null') {
	    return 0;
	}
	$focus{$x} = $nratoms;
	$nratoms ++;
	# add and delete hashkey _ so that the hash is defined (for dumpcore)
	$atom[$focus{$x}]{_} = 1;
	delete $atom[$focus{$x}]{_};
	if (defined $::coreview) {
	    print FLUID "new($x, $focus{$x})\n";
	    $ack = <ACK>;
	}
	return 1;
    } elsif ($opc eq 'REMFOCUS') {
	$x = shift @i;
	focus_null($x);
	return 1;
    } elsif ($opc eq 'NEWFIELD') {
	$x = shift @i;
	$f = shift @i;
	if (is_null($x)) {
	    return 0;
	}
	if (defined $atom[$focus{$x}]{$f}) {
	    return 0;
	} else {
	    $atom[$focus{$x}]{$f} = $focus{$x};
	    if (defined $::coreview) {
		print FLUID "addfield($x, $f)\n";
		$ack = <ACK>;
	    }
	    return 1;
	}
    } elsif ($opc eq 'REMFIELD') {
	$x = shift @i;
	$f = shift @i;
	if (is_null($x)) {
	    return 0;
	}
	if (defined $atom[$focus{$x}]{$f}) {
	    delete $atom[$focus{$x}]{$f};
	    if (defined $::coreview) {
		print FLUID "delfield($x, $f)\n";
		$ack = <ACK>;
	    }
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'MUTFIELD') {
	$x = shift @i;
	$f = shift @i;
	$y = shift @i;
	if (is_null($x)) {
	    return 0;
	}
	if (! defined $focus{$y}) {
	    if (defined $atom[$focus{$x}]{$f}) {
		$atom[$focus{$x}]{$f} = 0;
		if (defined $::coreview) {
		    print FLUID "setfield($x, $f, null)\n";
		    $ack = <ACK>;
		}
		return 1;
	    } else {
		return 0;
	    }
	}
	if (defined $atom[$focus{$x}]{$f}) {
	    $atom[$focus{$x}]{$f} = $focus{$y};
	    if (defined $::coreview) {
		if ($focus{$y} == 0) { # null
		    print FLUID "setfield($x, $f, null)\n";
		} else {
		    print FLUID "setfield($x, $f, $y)\n";
		}
		$ack = <ACK>;
	    }
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'SELFIELD') {
	$x = shift @i;
	$y = shift @i;
	$f = shift @i;
	if ($x eq 'null') {
	    return 0;
	}
	if (is_null($y)) {
	    return 0;
	}
	if (defined $atom[$focus{$y}]{$f}) {
	    if ($atom[$focus{$y}]{$f} == 0) { # y.f == null
		if (defined $focus{$x}) {
		    focus_null($x);
		}
	    } else {
		$focus{$x} = $atom[$focus{$y}]{$f};
		if (defined $::coreview) {
		    print FLUID "selfield($x, $y, $f)\n";
		    $ack = <ACK>;
		}
	    }
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'ASSIGN') {
	$x = shift @i;
	$y = shift @i;
	if ($x eq 'null') {
	    return 0;
	}
	if (! defined $focus{$y}) {
	    focus_null($x);
	    return 1;
	}
	$focus{$x} = $focus{$y};
	if (defined $::coreview) {
	    print FLUID "setfocus($x, $y)\n";
	    $ack = <ACK>;
	}
	return 1;
    } elsif ($opc eq 'EQUAL') {
	$x = shift @i;
	$y = shift @i;
	if (! defined $focus{$x}) {
	    if ($y eq 'null') {
		return 1;
	    }
	    if (! defined $focus{$y} || $focus{$y} == $focus{null}) {
		return 1;
	    }
	    return 0;
	}
	if (! defined $focus{$y}) {
            if ($focus{$x} == $focus{null}) {
                return 1;
            }
	    return 0;
	}
	if ($focus{$x} == $focus{$y}) {
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'MEMBER') {
	$x = shift @i;
	$f = shift @i;
	if (is_null($x)) {
	    return 0;
	}
	if (defined $atom[$focus{$x}]{$f}) {
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'REMATOM') {
	$x = shift @i;
	if (! defined $focus{$x}) {
	    return 0;
	} else {
	    if (linked($x)) {
		return 0;
	    }
	    if ($focus{$x} == $focus{null}) {
		return 0;
	    }
	    $nr = $focus{$x};
	    focus_null($x);
	    foreach $f (keys %{$atom[$nr]}) {
		if (defined $::coreview) {
		    print FLUID "delfield($nr, $f)\n";
		    $ack = <ACK>;
		}
	    }
	    rma($nr);
	    return 1;
	}
    } elsif ($opc eq 'RGC') {
	&rgc;
	return 1;
    } elsif ($opc eq 'FGC') {
	&fgc;
	return 1;
    }
}

sub linked {
    my $x = shift;
    my $nr;
    my $f;
    my $i;

    $nr = $focus{$x};
    foreach $f (keys %focus) {
	if ($f ne $x && $focus{$f} == $nr) {
	    return 1;
	}
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]}) {
	    foreach $f (keys %{$atom[$i]}) {
		if ($atom[$i]{$f} == $nr) {
		    return 1;
		}
	    }
	}
    }
    return 0;
}

sub rma {
    my $nr = shift;

    $atom[$nr] = undef;
    if (defined $::coreview) {
	print FLUID "rematom($nr)\n";
	$ack = <ACK>;
    }
}

sub rgc {
    my $i;
    my $f;

    for ($i = 0; $i <= $#atom; $i ++) {
#	if (%{$atom[$i]}) {
	if (defined $atom[$i]) {
	    $link[$i] = 0;
	} else {
	    $link[$i] = undef;
	}
    }
    foreach $f (keys %focus) {
	$link[$focus{$f}] ++;
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]}) {
	    foreach $f (keys %{$atom[$i]}) {
		$link[$atom[$i]{$f}] ++;
	    }
	}
    }
    $run = 0;
    do {
	$run ++;
	$removed = 0;
	@garbage = ();
	for ($i = 0; $i <= $#atom; $i ++) {
	    if (defined $link[$i] && $link[$i] == 0) {
		push @garbage, $i;
	    }
	}
	foreach $a (@garbage) {
#print "run $run removing $a\n";
	    foreach $f (keys %{$atom[$a]}) {
		if (defined $::coreview) {
		    print FLUID "delfield($a, $f)\n";
		    $ack = <ACK>;
		}
		$link[$atom[$a]{$f}] --;
	    }
	    rma($a);
	    $link[$a] = undef;
	    $removed ++;
	}
	if ($::gui) {
	    if (GUI->CheckStop) {
		goto ENDRGC;
	    }
	} else {
	    if (TUI->CheckStop) {
		goto ENDRGC;
	    }
	}
    } while ($removed);
ENDRGC:
}

sub reach {
    my $a = shift;
    my $f;

    if ($reached[$a]) {
	return;
    }
    $reached[$a] = 1;
    foreach $f (keys %{$atom[$a]}) {
	reach($atom[$a]{$f});
    }
}

sub fgc {
    my $i;
    my $f;
    my $a;

    for ($i = 0; $i <= $#atom; $i ++) {
#	if (%{$atom[$i]}) {
	if (defined $atom[$i]) {
	    $reached[$i] = 0;
	} else {
	    $reached[$i] = undef;
	}
	$deleted[$i] = 0;
    }
    foreach $f (keys %focus) {
	$a = $focus{$f};
	reach($a);
    }
    # first delete all fields and then the atoms, otherwise problems with fluid
    for ($i = 0; $i <= $#atom; $i ++) {
	if (defined $reached[$i] && $reached[$i] == 0) {
	    foreach $f (keys %{$atom[$i]}) {
		if (defined $::coreview) {
		    print FLUID "delfield($i, $f)\n";
		    $ack = <ACK>;
		}
	    }
	    $deleted[$i] = 1;
	}
	if ($::gui) {
	    if (GUI->CheckStop) {
		last;
	    }
	} else {
	    if (TUI->CheckStop) {
		last;
	    }
	}
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (! defined $reached[$i]) {
	    next;
	}
	if ($deleted[$i]) {
	    next;
	}
	foreach $f (keys %{$atom[$i]}) {
	    if ($deleted[$atom[$i]{$f}]) {
		if (defined $::coreview) {
		    print FLUID "delfield($i, $f)\n";
		    $ack = <ACK>;
		}
		delete $atom[$i]{$f};
	    }
	}
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (defined $reached[$i] && $reached[$i] == 0 && $deleted[$i]) {
	    rma($i);
	}
    }
}

sub DumpCore {
    my $self = shift;
    my $f;
    my $i;

    print "foci:\n";
    foreach $f (keys %focus) {
	print "    $f    $focus{$f}\n";
    }
    print "atoms:\n";
    for ($i = 0; $i <= $#atom; $i ++) {
#	if (%{$atom[$i]}) {
	if (defined $atom[$i]) {
	    print "    $i\n";
	    foreach $f (keys %{$atom[$i]}) {
		print "        $f    $atom[$i]{$f}\n";
	    }
	}
    }
#    if (defined $::coreview) {
#	print FLUID "dump\n";
#	while (<ACK>) {
#	    if (/^ack$/) {
#		last;
#	    }
#	    print $_;
#	}
#    }
}

use FileHandle;
use IPC::Open2;

sub stop {
    print FLUID "quit\n";
    exit;
}

sub InitCore {
    my $self = shift;
    my $f;

    undef %focus;
    undef @atom;
    $nratoms = 0;
    if (defined $::coreview) {
	if (! fileno FLUID) {
	    $SIG{INT} = 'IGNORE';
	    $bin = Global::Get('BINDIR');
	    $pid = open2(\*ACK, \*FLUID, "$bin/fluidint $::fluidoptions -b MPP");
	    $SIG{INT} = \&stop;
	} else {
	    print FLUID "reset\n";
	    $ack = <ACK>;
	}
    }
    # add the null
    $x = 'null';
    $focus{$x} = $nratoms;
    $nratoms ++;
    # add and delete hashkey _ so that the hash is defined (for dumpcore)
    $atom[$focus{$x}]{_} = 1;
    delete $atom[$focus{$x}]{_};
    if (! defined $::nonull) {
	if (defined $::coreview) {
	    print FLUID "new($x, $focus{$x})\n";
	    $ack = <ACK>;
	}
    }
}

$coreviewupdate = 1;

sub SetUpdate {
    my $self = shift;
    my $update = shift;

    if (defined $::coreview) {
        $coreviewupdate = $update;
        print FLUID "doupdates($update)\n";
        $ack = <ACK>;
    }
}

sub Update {

    if ($coreviewupdate == 0) {
        if (defined $::coreview) {
            print FLUID "update\n";
            $ack = <ACK>;
        }
    }
}

END {
    if (defined $::coreview) {
	if (fileno FLUID) {
	    print FLUID "quit\n";
	}
    }
}

1;
