
package MPPVcore;

$VERSION = "1.02";

use Global;
use FluidGC;

require Exporter;
@ISA = qw( FluidGC Exporter );
@EXPORT = @FluidGC::EXPORT;

sub IsReserved {
    my $x = shift;

    if ($x eq 'null' || $x eq 'true' || $x eq 'false') {
	return 1;
    }
    return 0;
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;
    my $t;

    $opc = shift @i;
    if ($opc eq 'NEWATOM') {
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	NewFocus($x);
	return 1;
    } elsif ($opc eq 'REMFOCUS') {
        $x = shift @i;
	RemoveFocus($x);
        return 1;
    } elsif ($opc eq 'NEWFIELD') {
	$x = shift @i;
	$f = shift @i;
        if (! ($a = GetFocus($x))) {
            return 0;
        }
        if (HasField($a, $f)) {
            return 0;
        } else {
            AddField($a, $f);
            return 1;
        }
    } elsif ($opc eq 'NEWVALFIELD') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
        if (! ($a = GetFocus($x))) {
            return 0;
        }
        if (HasField($a, $f)) {
            return 0;
        } else {
            AddValueField($a, $f, $t, DefaultValue($t));
            return 1;
        }
    } elsif ($opc eq 'REMFIELD') {
	$x = shift @i;
	$f = shift @i;
        if (! ($a = GetFocus($x))) {
            return 0;
        }
        if (HasField($a, $f)) {
            if (! IsFieldType($a, $f, 'NONE')) {
                DelValueField($a, $f);
            } else {
                DelField($a, $f);
            }
            return 1;
        } else {
            return 0;
        }
    } elsif ($opc eq 'MUTFIELD') {
	$x = shift @i;
	$f = shift @i;
	$y = shift @i;
        if (! ($ax = GetFocus($x))) {
            return 0;
        }
        if (! HasField($ax, $f)) {
	    return 0;
	}
	$ay = GetFocus($y);
	if (GetFieldType($ax, $f) ne GetType($ay)) {
	    return 0;
	}
	if (IsType($ay, 'NONE')) {
	    SetField($ax, $f, $ay);
	} else {
	    SetFieldValue($ax, $f, GetType($ay), GetValue($ay));
	}
	return 1;
    } elsif ($opc eq 'MUTVALFIELD') {
	$x = shift @i;
	$f = shift @i;
	$v = shift @i;
	$t = shift @i;
	if (IsReserved($x)) {
	    return 0;
	}
	if (! ($a = GetFocus($x))) {
	    return 0;
	}
	if (! HasField($a, $f)) {
	    return 0;
	}
	if (IsFieldType($a, $f, $t)) {
	    SetFieldValue($a, $f, $t, $v);
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'SELFIELD') {
	$x = shift @i;
	$y = shift @i;
	$f = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	$ay = GetFocus($y);
	if (! HasField($ay, $f)) {
	    return 0;
	}
	$ay = GetField($ay, $f);
	SetFocus($x, $ay);
	return 1;
    } elsif ($opc eq 'ASSIGN') {
	$x = shift @i;
	$y = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	$ay = GetFocus($y);
	SetFocus($x, $ay);
	return 1;
    } elsif ($opc eq 'VALASSIGN') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	SetFocusValue($x, $t, $v);
	return 1;
    } elsif ($opc eq 'EQUAL') {
	$x = shift @i;
	$y = shift @i;
	$ax = GetFocus($x);
	$ay = GetFocus($y);
	return Equal($ax, $ay);
    } elsif ($opc eq 'VALEQUAL') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
	$ax = GetFocus($x);
        if (IsType($ax, $t) && GetValue($ax) eq $v) {
            return 1;
        } else {
            return 0;
        }
    } elsif ($opc eq 'MEMBER') {
	$x = shift @i;
	$f = shift @i;
	$ax = GetFocus($x);
        if (HasField($ax, $f)) {
            return 1;
        } else {
            return 0;
        }
    } elsif ($opc eq 'REMATOM') {
        $x = shift @i;
	return RemoveAtom($x);
    } elsif ($opc eq 'RGC') {
        RestrictedGC();
        return 1;
    } elsif ($opc eq 'FGC') {
        FullGC();
        return 1;
    }
}

sub DumpCore {
    FluidBase->DumpFluid();
}

sub InitCore {
    FluidBase->InitFluid();
}

1;
