
package MPP;

$VERSION = "0.15";

use Global;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
	die "module BI_TB not found\n";
    }
    @ISA = qw( BI_TB );
} else {
    if (! eval {require "MPPcore.pm"}) {
	die "module MPPcore not found\n";
    }
    @ISA = qw( MPPcore );
}

$id = '[a-zA-Z][a-zA-Z0-9]*';

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^($id)\s*=\s*new$/) {
	@prim = ( 'NEWATOM', $1 );
    } elsif ($i =~ /^($id)\s*=\s*null$/) {
	@prim = ( 'REMFOCUS', $1 );
    } elsif ($i =~ /^($id)\.\+($id)$/) {
	@prim = ( 'NEWFIELD', $1, $2 );
    } elsif ($i =~ /^($id)\.-($id)$/) {
	@prim = ( 'REMFIELD', $1, $2 );
    } elsif ($i =~ /^($id)\.($id)\s*=\s*($id)$/) {
	@prim = ( 'MUTFIELD', $1, $2, $3 );
    } elsif ($i =~ /^($id)\s*=\s*($id)\.($id)$/) {
	@prim = ( 'SELFIELD', $1, $2, $3 );
    } elsif ($i =~ /^($id)\s*=\s*($id)$/) {
	@prim = ( 'ASSIGN', $1, $2 );
    } elsif ($i =~ /^($id)\s*==\s*($id)$/) {
	@prim = ( 'EQUAL', $1, $2 );
    } elsif ($i =~ /^($id)\s*\/\s*($id)$/) {
	@prim = ( 'MEMBER', $1, $2 );
    } elsif ($i =~ /^rma\s+($id)$/) {
	@prim = ( 'REMATOM', $1 );
    } elsif ($i =~ /^rgc$/) {
	@prim = ( 'RGC' );
    } elsif ($i =~ /^fgc$/) {
	@prim = ( 'FGC' );
    } else {
	@prim = ( 'ERROR' );
#	print "\nunknown primitive: $i\n";
    }
#    print "prim: " . join("*", @prim) . "\n";
    return @prim
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'NEWATOM') {
	$x = shift @i;
	return "$x = new";
    } if ($opc eq 'REMFOCUS') {
	$x = shift @i;
	return "$x = null";
    } elsif ($opc eq 'NEWFIELD') {
	$x = shift @i;
	$f = shift @i;
	return "$x.+$f";
    } elsif ($opc eq 'REMFIELD') {
	$x = shift @i;
	$f = shift @i;
	return "$x.-$f";
    } elsif ($opc eq 'MUTFIELD') {
	$x = shift @i;
	$f = shift @i;
	$y = shift @i;
	return "$x.$f = $y";
    } elsif ($opc eq 'SELFIELD') {
	$x = shift @i;
	$y = shift @i;
	$f = shift @i;
	return "$x = $y.$f";
    } elsif ($opc eq 'ASSIGN') {
	$x = shift @i;
	$y = shift @i;
	return "$x = $y";
    } elsif ($opc eq 'EQUAL') {
	$x = shift @i;
	$y = shift @i;
	return "$x == $y";
    } elsif ($opc eq 'MEMBER') {
	$x = shift @i;
	$f = shift @i;
	return "$x/$f";
    } elsif ($opc eq 'REMATOM') {
	$x = shift @i;
	return "rma $x";
    } elsif ($opc eq 'RGC') {
	return "rgc";
    } elsif ($opc eq 'FGC') {
	return "fgc";
    }
}

1;
