
package LISP;

$VERSION = "1.00";

use Global;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
        die "module BI_TB not found\n";
    }
    @ISA = qw( BI_TB );
} else {
    if (! eval {require "LISPcore.pm"}) {
        die "module LISPcore not found\n";
    }
    @ISA = qw( LISPcore );
}

$id = '[a-zA-Z][a-zA-Z0-9]*';
$object = '[a-zA-Z][a-zA-Z0-9\.]*';
$int = '[0-9]+';
$bool = '(true|false)';
$str = '\".*\"';
$val = "$int|$bool|$str";

sub value_type {
    my $v = shift;
    my $t;

    if ($v =~ /^$int$/) {
	$t = 'int';
    } elsif ($v =~ /^$bool$/) {
	$t = 'bool';
    } elsif ($v =~ /^$str$/) {
	$t = 'str';
    } else {
	$t = 'unknown';
    }
    return $t;
}

sub proper_value {
    my $v = shift;

    if ($v =~ /^\"(.*)\"$/) {
	$v = $1;
	$v =~ s/\\(\\|")/$1/g;
    }
    return $v;
}

my $inputstr;

sub next_token {
    $inputstr =~ s/^\s*//;
    if ($inputstr =~ /^\]/) {
	return ')';
    } elsif ($inputstr =~ /^(\(|\)|\.|\'|$id)/) {
	$inputstr = $';
	return uc $&;
    } else {
	return undef;
    }
}

sub parse_elements {
    my $t;
    my @elem = ();

    while ($t = next_token()) {
	if ($t eq ')') {
	    push @elem, 'NIL';
	    return @elem;
	}
	if ($t eq '.') {
	    if ($#elem == 0) {
		$t = next_token();
		if ($t =~ /^$id$/) {
		    push @elem, $t;
		    $t = next_token();
		    if ($t eq ')') {
			return @elem;
		    }
		} elsif ($t eq '(') {
		    @sublist = parse_elements();
		    if (! defined $sublist[0]) {
			return undef;
		    }
		    push @elem, [(@sublist)];
		    return @elem;
		}
	    }
	    return undef;
	} elsif ($t eq '\'') {
	    $t = next_token();
	    if ($t =~ /^$id$/) {
		push @elem, [('QUOTE', $t, NIL)];
	    } elsif ($t eq '(') {
		@sublist = parse_elements();
		if (! defined $sublist[0]) {
		    return undef;
		}
		push @elem, [('QUOTE', [(@sublist)], NIL)];
	    } else {
		return undef;
	    }
	} else {
	    if ($t eq '(') {
		@sublist = parse_elements();
		if (! defined $sublist[0]) {
		    return undef;
		}
		push @elem, [(@sublist)];
	    } else {
		if ($t =~ /^$id$/) {
		    push @elem, $t;
		} else {
		    return undef;
		}
	    }
	}
    }
    return undef;
}

sub parse_list {
    my $i = shift;
    my $t;

    $inputstr = $i;
    if (! ($t = next_token())) {
	return undef;
    }
    if ($t ne '(') {
	return undef;
    }
    @elem = parse_elements();
    if (! defined $elem[0]) {
	return undef;
    }
    return @elem;
}

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^$id$/) {
	@prim = ('SYMBOL', uc $i);
    } else {
	@list = parse_list($i);
	if (defined $list[0]) {
	    @prim = ( 'LIST', [ @list ]);
	} else {
	    @prim = ( 'ERROR' );
	}
    }
#$s = $self->Print(@prim);
#print "parsed < $s >\n";
    return @prim;
}

sub print_list {
    my $list = shift;
    my $s = "";
    my $ss;
    my $e;
    my $first = 1;
    my $i;

    $s .= "(";
    $i = 0;
    foreach $e (@{$list}) {
	if ($first) {
	    $first = 0;
	} else {
	    if ($i == $#{$list}) {
		if ($e eq 'NIL') {
		    last;
		} else {
		    $s .= " . ";
		}
	    } else {
		$s .= " ";
	    }
	}
	if (ref $e) {
	    $ss = print_list($e);
	    $s .= $ss;
	} else {
	    $s .= $e;
	}
	$i ++;
    }
    $s .= ")";
    return $s;
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'LIST') {
	$x = shift @i;
	return print_list($x);
    } elsif ($opc eq 'SYMBOL') {
	return shift @i;
    }
}

1;
