
package InverseSelect;

$VERSION = "0.00";

use Global;
use FluidTypes;
use FluidBase;
use ExtendedFocus;

require Exporter;
@ISA = qw( ExtendedFocus FluidBase FluidTypes Exporter );
@EXPORT = @ExtendedFocus::EXPORT;
push @EXPORT, qw( ReduceInverseSelect );

sub InverseSelect {
    my $x = shift;
    my $y = shift;

    if (! defined ($ax = ExtendedFocusValue($x))) {
	return undef;
    }
    if (! IsType($ax, 'NONE')) {
	return undef;
    }
    if (! ($ay = ExtendedFocusValue($y))) {
	return undef;
    }
    if (! IsType($ay, 'NONE')) {
	return undef;
    }
    $n = undef;
    foreach $f (keys %{$atom[$ay]}) {
	if (IsFieldType($ay, $f, 'NONE')) {
	    if ($ax == GetField($ay, $f)) {
		if (defined $n) {
		    return undef;
		}
		$n = $f;
	    }
	}
    }
    return $n;
}

sub ReduceInverseSelect {
    my $s = shift;
    my $r;
    my $is;

    $r = "";
    while ($s) {
	if ($s =~ /^\((.*)-(.*)\)/) {
	    $s = $';
	    if (! ($is = InverseSelect($1, $2))) {
		return undef;
	    }
	    $r .= $is;
	} elsif ($s =~ /^([^\.]*)/) {
	    $r .= $1;
	    $s = $';
	}
	if ($s =~ /^\./) {
	    $r .= ".";
	    $s = $';
	}
#print STDERR "ris: $r - $s -\n";
    }
#print STDERR "risret: $r -\n";
    return $r;
}
