
package Input;

$VERSION = "0.06";

$buffer = "";
$stream;
$myeof = 0;

sub Stream {
    my $self = shift;

    $stream = shift;
    $myeof = 0;
}

sub String {
    my $self = shift;

    $buffer = shift;
    $myeof = 1;
}

#$sep = "^([^\\\";]*(\\\"([^\\\"\\\\]|\\\\\\\\|\\\\\\\")*\\\")?)*;";
$sep = qr/^([^\";]*(\"([^\"\\]|\\\\|\\\"|\\n)*\")?)*;/o;

sub Next {
    my $self = shift;
    my $i;

    if ($myeof && buffer eq "") {
	return "";
    }
    $i = "";
    if ($buffer =~ /$sep/) {
	$i = $&;
	$buffer = $';
	chop $i;
    } else {
	if (! $myeof) {
	    while (<$stream>) {
		chomp; # remove line ending if there
#		print STDERR "input: <$_>\n";
		$_ = $buffer . $_;
		if (/$sep/) {
		    $i = $&;
		    $buffer = $';
		    chop $i;
		    if (eof($stream)) {
			$myeof = 1;
			last;
		    }
		    last;
		} else {
		    $buffer = $_;
		}
		if (eof($stream)) {
		    $myeof = 1;
		    last;
		}
	    }
	}
	if ($i eq "") {
	    $i = $buffer;
	    $buffer = "";
	}
    }
    if ($i =~ /^\s*(.*\S)\s*$/o) {
	$i = $1;
    }
#    print STDERR "instr: <$i>\n";
    return($i);
}

1;
