
package HMPPVcore;

$VERSION = "1.03";

use Global;
use FluidGC;
use ExtendedFocus;

require Exporter;
@ISA = qw( ExtendedFocus FluidGC Exporter );
@EXPORT = ( @ExtendedFocus::EXPORT, @FluidGC::EXPORT );
push @EXPORT, qw( IsReserved AssignValue );

sub IsReserved {
    my $x = shift;

    if ($x eq 'null' || $x eq 'true' || $x eq 'false') {
	return 1;
    }
    return 0;
}

sub AssignValue {
    my $x = shift;
    my $v = shift;
    my $t = shift;

    if (IsFocusName($x)) {
	$ax = GetFocus($x);
        SetFocusValue($x, $t, $v);
        return 1;
    } else {
        ($a, $f) = ExtendedFocus($x);
        if ($a == -1) {
            return 0;
        }
        if (! IsFieldType($a, $f, $t)) {
            return 0;
        }
        SetFieldValue($a, $f, $t, $v);
        return 1;
    }
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;
    my $t;
    my $a;
    my $na;

    $opc = shift @i;
#print "opc: $opc\n";
    if ($opc eq 'NEWATOM') {
	$x = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if (IsFocusName($x)) {
	    NewFocus($x);
	    return 1;
	} else {
	    ($a, $f) = ExtendedFocus($x);
	    if ($a == -1) {
		return 0;
	    }
	    if (! IsFieldType($a, $f, 'NONE')) {
		return 0;
	    }
	    SetFieldNew($a, $f);
	    return 1;
	}
    } elsif ($opc eq 'REMFOCUS') {
        $x = shift @i;
	RemoveFocus($x);
        return 1;
    } elsif ($opc eq 'NEWFIELD') {
	$x = shift @i;
	$f = shift @i;
	if (! ($a = ExtendedFocusTypedValue($x, 'NONE'))) {
	    return 0;
	}
	if (HasField($a, $f)) {
	    return 0;
	} else {
	    AddField($a, $f);
	    return 1;
	}
    } elsif ($opc eq 'NEWVALFIELD') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	if (! ($a = ExtendedFocusTypedValue($x, 'NONE'))) {
	    return 0;
	}
	if (HasField($a, $f)) {
	    return 0;
	} else {
	    AddValueField($a, $f, $t, DefaultValue($t));
	    return 1;
	}
    } elsif ($opc eq 'NEWFIELDASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$y = shift @i;
	if (! ($ax = ExtendedFocusTypedValue($x, 'NONE'))) {
	    return 0;
	}
	if (HasField($ax, $f)) {
	    return 0;
	} else {
	    if ($y eq 'new') {
		SetFieldNew($ax, $f);
	    } else {
		if (! defined ($ay = ExtendedFocusTypedValue($y, 'NONE'))) {
		    return 0;
		}
		if (IsFocusName($y)) {
		    $ay = GetFocus($y);
		    if (! IsType($ay, 'NONE')) {
			return 0;
		    }
		} else {
		    ($ay, $fy) = ExtendedFocus($y);
		    if ($ay == -1) {
			return 0;
		    }
		    if (! IsFieldType($ay, $fy, 'NONE')) {
			return 0;
		    }
		    $ay = GetField($ay, $fy);
		}
		SetField($ax, $f, $ay);
	    }
	    return 1;
	}
    } elsif ($opc eq 'NEWVALFIELDVALASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$v = shift @i;
	if (! ($ax = ExtendedFocusTypedValue($x, 'NONE'))) {
	    return 0;
	}
	if (HasField($ax, $f)) {
	    return 0;
	} else {
	    AddValueField($ax, $f, $t, $v);
	    return 1;
	}
    } elsif ($opc eq 'NEWVALFIELDASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$y = shift @i;
	if (! ($ax = ExtendedFocusTypedValue($x, 'NONE'))) {
	    return 0;
	}
	if (HasField($ax, $f)) {
	    return 0;
	} else {
	    if (! ($ay = ExtendedFocusTypedValue($y, $t))) {
		return 0;
	    }
	    AddValueField($ax, $f, $t, GetValue($ay));
	    return 1;
	}
    } elsif ($opc eq 'REMFIELD') {
	$x = shift @i;
	$f = shift @i;
	if (! ($a = ExtendedFocusTypedValue($x, 'NONE'))) {
	    return 0;
	}
	if (HasField($a, $f)) {
	    if (! IsFieldType($a, $f, 'NONE')) {
		DelValueField($a, $f);
	    } else {
		DelField($a, $f);
	    }
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'ASSIGN') {
	$x = shift @i;
	$y = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	if (IsFocusName($y)) {
	    $ay = GetFocus($y);
	} else {
	    ($ay, $fy) = ExtendedFocus($y);
	    if ($ay == -1) {
		return 0;
	    }
	    $ay = GetField($ay, $fy);
	}
	if (IsFocusName($x)) {
	    SetFocus($x, $ay);
	    return 1;
	} else {
	    ($ax, $fx) = ExtendedFocus($x);
	    if ($ax == -1) {
		return 0;
	    }
	    if (GetFieldType($ax, $fx) ne GetType($ay)) {
		return 0;
	    }
	    if (! IsType($ay, 'NONE')) {
		SetFieldValue($ax, $fx, GetType($ay), GetValue($ay));
	    } else {
		SetField($ax, $fx, $ay);
	    }
	    return 1;
	}
    } elsif ($opc eq 'VALASSIGN') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
        if (IsReserved($x)) {
            return 0;
        }
	return AssignValue($x, $v, $t);
    } elsif ($opc eq 'EQUAL') {
	$x = shift @i;
	$y = shift @i;
	if (IsFocusName($x)) {
	    $ax = GetFocus($x);
	} else {
	    ($ax, $fx) = ExtendedFocus($x);
	    if ($ax == -1) {
		return 0;
	    }
	    $ax = GetField($ax, $fx);
	}
	if (IsFocusName($y)) {
	    $ay = GetFocus($y);
	} else {
	    ($ay, $fy) = ExtendedFocus($y);
	    if ($ay == -1) {
		return 0;
	    }
	    $ay = GetField($ay, $fy);
	}
	return Equal($ax, $ay);
    } elsif ($opc eq 'VALEQUAL') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
	if (! ($ax = ExtendedFocusValue($x))) {
	    return 0;
	}
	if (IsType($ax, $t) && GetValue($ax) eq $v) {
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'MEMBER') {
	$x = shift @i;
	$f = shift @i;
	if (! ($ax = ExtendedFocusValue($x))) {
	    return 0;
	}
	if (HasField($ax, $f)) {
	    return 1;
	} else {
	    return 0;
	}
    } elsif ($opc eq 'REMATOM') {
        $x = shift @i;
	return RemoveAtom($x);
    } elsif ($opc eq 'RGC') {
        RestrictedGC();
        return 1;
    } elsif ($opc eq 'FGC') {
        FullGC();
        return 1;
    } elsif ($opc eq 'TYPEFIELD') {
	$x = shift @i;
	$t = shift @i;
	if (IsFocusName($x)) {
	    if (IsType(GetFocus($x), $t)) {
		return 1;
	    } else {
		return 0;
	    }
	}
	($ax, $fx) = ExtendedFocus($x);
	if ($ax == -1) {
	    return 0;
	}
	if (IsFieldType($ax, $fx, $t)) {
	    return 1;
	} else {
	    return 0;
	}
    } else {
	return 0;
    }
}

sub InitCore {
    FluidBase->InitFluid();
}

sub DumpCore {
    FluidBase->DumpFluid();
}

1;
