
package HMPPV_CG;

$VERSION = "0.00";

use Fluid_CG;
use CG;

@ISA = qw( Fluid_CG CG );

sub CG {
    my $self = shift;
    my $false = shift;
    my @i = @_;
    my $opc = shift @i;
    my ($x, $y, $f, $t, $v);
    my ($preg1, $preg2, $preg3);
    my ($sreg1, $sreg2);
    my ($ireg1, $ireg2);

    if ($opc eq 'NEWATOM') {
	$x = shift @i;
	if (IsReserved($x)) {
	    gotolabel($false);
	    return;
	}
	$preg1 = AllocPreg();
	if (IsFocusName($x)) {
	    NewAtom($preg1, "atom");
	    setfocus($x, $preg1);
	}{
	    GetLValue($preg1, $x, "atom", $false);
	    $preg2 = AllocPreg();
	    NewAtom($preg2, "atom");
	    setvalue($preg1, $preg2);
	    FreePreg($preg2);
	}
	FreePreg($preg1);
    } elsif ($opc eq 'REMFOCUS') {
	$x = shift @i;
	focusexists($x, $false);
	removefocus($x);
    } elsif ($opc eq 'NEWFIELD') {
	$x = shift @i;
	$f = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	HasField(0, $preg1, $f, $false);
	setfield($preg1, $f, $preg1);
	FreePreg($preg1);
    } elsif ($opc eq 'NEWVALFIELD') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	HasField(0, $preg1, $f, $false);
	$preg2 = AllocPreg();
	NewAtom($preg2, $t);
	if ($t eq 'int') {
	    setvalue_intv($preg2, 0);
	} elsif ($t eq 'bool') {
	    setvalue_intv($preg2, 0);
	} else { # str
	    setvalue_strv($preg2, '""');
	}
	setfield($preg1, $f, $preg2);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'NEWFIELDASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$y = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	HasField(0, $preg1, $f, $false);
	$preg2= AllocPreg();
	if ($y eq 'new') {
	    NewAtom($preg2, "atom");
	} else {
	    GetExistLValue($preg2, $y, "atom", $false);
	}
	setfield($preg1, $f, $preg2);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'NEWVALFIELDVALASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$v = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	HasField(0, $preg1, $f, $false);
	$preg2= AllocPreg();
	NewAtom($preg2, $t);
	if ($t eq 'str') {
	    $v = PrintValue($t, $v);
	    setvalue_strv($preg2, $v);
	} elsif ($t eq 'int') {
	    setvalue_intv($preg2, $v);
	} else { # bool
	    if ($v eq 'true') {
		$v = 1;
	    } else {
		$v = 0;
	    }
	    setvalue_intv($preg2, $v);
	}
	setfield($preg1, $f, $preg2);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'NEWVALFIELDASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$y = shift @i;
	$preg2 = AllocPreg();
	GetExistLValue($preg2, $y, $t, $false);
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	HasField(0, $preg1, $f, $false);
	$preg3 = AllocPreg();
	NewAtom($preg3, $t);
	if ($t eq 'str') {
	    $sreg1 = AllocSreg();
	    getvalue_str($sreg1, $preg2);
	    setvalue_str($preg3, $sreg1);
	    FreeSreg($sreg1);
	} else {
	    $ireg1 = AllocIreg();
	    getvalue_int($ireg1, $preg2);
	    setvalue_int($preg3, $ireg1);
	    FreeIreg($ireg1);
	}
	setfield($preg1, $f, $preg3);
	FreePreg($preg3);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'REMFIELD') {
	$x = shift @i;
	$f = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	HasField(1, $preg1, $f, $false);
	removefield($preg1, $f);
	FreePreg($preg1);
    } elsif ($opc eq 'ASSIGN') {
	$x = shift @i;
	$y = shift @i;
	if (IsReserved($x)) {
	    gotolabel($false);
	    return;
	}
	$preg2 = AllocPreg();
	GetValue($preg2, $y, $false);
	if (IsFocusName($x)) {
	    $sreg2 = AllocSreg();
	    gettype($sreg2, $preg2);
	    SetFocus($x, $preg2, $sreg2, $false);
	    FreeSreg($sreg2);
	} else {
	    $preg1 = AllocPreg();
	    $f = GetAtomField($preg1, $x, $false);
	    $sreg2 = AllocSreg();
	    gettype($sreg2, $preg2);
	    $l_else = getLocalLabel();
	    $l_end = getLocalLabel();
	    equal_strv($sreg2, "\"atom\"", $l_else);
	    $p = AllocPreg();
	    getfield($p, $preg1, $f);
	    IsType($p, "atom", $false);
	    FreePreg($p);
	    setfield($preg1, $f, $preg2);
	    gotolabel($l_end);
	    OutputLabel($l_else);
	    getfield($preg1, $preg1, $f);
	    $sreg1 = AllocSreg();
	    gettype($sreg1, $preg1);
	    equal_str($sreg1, $sreg2, $false);
	    FreeSreg($sreg1);
	    getvalue($preg2, $preg2);
	    setvalue($preg1, $preg2);
	    OutputLabel($l_end);
	    FreeSreg($sreg2);
	    FreePreg($preg1);
	}
	FreePreg($preg2);
    } elsif ($opc eq 'VALASSIGN') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
	if (IsReserved($x)) {
	    gotolabel($false);
	    return;
	}
	$preg1 = AllocPreg();
	GetLValue($preg1, $x, $t, $false);
	if ($t eq 'str') {
	    $v = PrintValue($t, $v);
	    setvalue_strv($preg1, $v);
	} elsif ($t eq 'int') {
	    setvalue_intv($preg1, $v);
	} else { # bool
	    if ($v eq 'true') {
		$v = 1;
	    } else {
		$v = 0;
	    }
	    setvalue_intv($preg1, $v);
	}
	FreePreg($preg1);
    } elsif ($opc eq 'EQUAL') {
	$x = shift @i;
	$y = shift @i;
	$preg1 = AllocPreg();
	GetValue($preg1, $x, $false);
	$preg2 = AllocPreg();
	GetValue($preg2, $y, $false);
	$sreg1 = AllocSreg();
	gettype($sreg1, $preg1);
	$sreg2 = AllocSreg();
	gettype($sreg2, $preg2);
	$l_end = getLocalLabel();
	$l_else = getLocalLabel();
	equal_str($sreg1, $sreg2, $false);
	FreeSreg($sreg2);
	$l_end = getLocalLabel();
	$l_else = getLocalLabel();
	equal_strv($sreg1, "\"atom\"", $l_else);
	equal($preg1, $preg2, $false);
	gotolabel($l_end);
	OutputLabel($l_else);
	$l_else = getLocalLabel();
	equal_strv($sreg1, "\"str\"", $l_else);
	$sreg2 = AllocSreg();
	getvalue_str($sreg1, $preg1);
	getvalue_str($sreg2, $preg2);
	equal_str($sreg1, $sreg2, $false);
	FreeSreg($sreg2);
	gotolabel($l_end);
	OutputLabel($l_else);
	$ireg1 = AllocIreg();
	$ireg2 = AllocIreg();
	getvalue_int($ireg1, $preg1);
	getvalue_int($ireg2, $preg2);
	equal_int($ireg1, $ireg2, $false);
	FreeIreg($ireg2);
	FreeIreg($ireg1);
	OutputLabel($l_end);
	FreeSreg($sreg1);
	FreePreg($preg2);
	FreePreg($preg1);
    } elsif ($opc eq 'VALEQUAL') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, $t, $false);
	if ($t eq 'int') {
	    $ireg1 = AllocIreg();
	    getvalue_int($ireg1, $preg1);
	    equal_intv($ireg1, $v, $false);
	    FreeIreg($ireg1);
	} elsif ($t eq 'bool') {
	    if ($v eq 'true') {
		$v = 1;
	    } else {
		$v = 0;
	    }
	    $ireg1 = AllocIreg();
	    getvalue_int($ireg1, $preg1);
	    equal_intv($ireg1, $v, $false);
	    FreeIreg($ireg1);
	} else { # str
	    $sreg1 = AllocSreg();
	    getvalue_str($sreg1, $preg1);
	    $v = PrintValue($t, $v);
	    equal_strv($sreg1, $v, $false);
	    FreeSreg($sreg1);
	}
	FreePreg($preg1);
    } elsif ($opc eq 'MEMBER') {
	$x = shift @i;
	$f = shift @i;
	$preg1 = AllocPreg();
	GetExistLValue($preg1, $x, "atom", $false);
	fieldexists($preg1, $f, $false);
	FreePreg($preg1);
    } elsif ($opc eq 'REMATOM') {
	# hmmm, if the ref isn't an atom or the atom is still linked,
	# we have to jump to the false label.
	# How can we determine if it is still linked???
    } elsif ($opc eq 'RGC') {
	# we don't do this ourselves.
    } elsif ($opc eq 'FGC') {
	# we don't do this ourselves.
    } elsif ($opc eq 'TYPEFIELD') {
	$x = shift @i;
	$t = shift @i;
	$preg1 = AllocPreg();
	if ($t eq 'NONE') {
	    $t = 'atom';
	}
	GetExistLValue($preg1, $x, $t, $false);
    }
}

1;
