
package HMPPV;

$VERSION = "1.04";

use Global;
use FluidValues;
use FluidObjects;

require Exporter;
@ISA = qw( FluidObjects FluidValues Exporter );
@EXPORT = (@FluidObjects::EXPORT, @FluidValues::EXPORT);

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
        die "module BI_TB not found\n";
    }
    unshift @ISA, qw( BI_TB );
} else {
    if (! eval {require "HMPPVcore.pm"}) {
        die "module HMPPVcore not found\n";
    }
    unshift @ISA, qw( HMPPVcore );
}

#$id = '[a-zA-Z][a-zA-Z0-9]*';
#$object = '[a-zA-Z][a-zA-Z0-9\.]*';

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^($object)\s*=\s*new$/) {
	@prim = ( 'NEWATOM', $1 );
    } elsif ($i =~ /^($id)\s*=\s*null$/) {
        @prim = ( 'REMFOCUS', $1 );
    } elsif ($i =~ /^($object)\.\+($id)$/) {
	@prim = ( 'NEWFIELD', $1, $2 );
    } elsif ($i =~ /^($object)\.\+($id)\s*=\s*($object)$/) {
	@prim = ( 'NEWFIELDASSIGN', $1, $2, $3 );
    } elsif ($i =~ /^($object)\.\+($id):($id)$/) {
	@prim = ( 'NEWVALFIELD', $1, $2, $3 );
    } elsif ($i =~ /^($object)\.\+($id):($id)\s*=\s*($value{any})$/) {
        $x = $1;
        $f = $2;
        $tf = $3;
        $v = $4;
        $tv = ValueType($v);
	$v = ProperValue($v);
        if ($tv eq $tf) {
            @prim = ( 'NEWVALFIELDVALASSIGN', $x, $f, $tf, $v );
        } else {
            @prim = ( 'ERROR' );
            print "\ntype clash: $tf = $tv\n";
        }
    } elsif ($i =~ /^($object)\.\+($id):($id)\s*=\s*($object)$/) {
	@prim = ( 'NEWVALFIELDASSIGN', $1, $2, $3, $4 );
    } elsif ($i =~ /^($object)\.-($id)$/) {
	@prim = ( 'REMFIELD', $1, $2 );
    } elsif ($i =~ /^($object)\s*=\s*($value{any})$/) {
	$x = $1;
	$v = $2;
	$t = ValueType($v);
	$v = ProperValue($v);
	@prim = ( 'VALASSIGN', $x, $v, $t );
    } elsif ($i =~ /^($object)\s*=\s*($object)$/) {
	@prim = ( 'ASSIGN', $1, $2 );
    } elsif ($i =~ /^($object)\s*==\s*($value{any})$/) {
	$x = $1;
	$v = $2;
	$t = ValueType($v);
	$v = ProperValue($v);
	@prim = ( 'VALEQUAL', $x, $v, $t );
    } elsif ($i =~ /^($object)\s*==\s*($object)$/) {
	@prim = ( 'EQUAL', $1, $2 );
    } elsif ($i =~ /^($object)\s*\/\s*($id)$/) {
	@prim = ( 'MEMBER', $1, $2 );
    } elsif ($i =~ /^rma\s+($id)$/) {
        @prim = ( 'REMATOM', $1 );
    } elsif ($i =~ /^rgc$/) {
        @prim = ( 'RGC' );
    } elsif ($i =~ /^fgc$/) {
        @prim = ( 'FGC' );
    } elsif ($i =~ /^($object)\?($types)$/) {
	@prim = ( 'TYPEFIELD', $1, $2 );
    } elsif ($i =~ /^($object)\?$/) {
	@prim = ( 'TYPEFIELD', $1, 'NONE' );
    } else {
        @prim = ( 'ERROR' );
#	print "\nunknown primitive: $i\n";
    }
#    print "prim: " . join("*", @prim) . "\n";
    return @prim
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $x;
    my $y;
    my $f;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'NEWATOM') {
	$x = shift @i;
	return "$x = new";
    } if ($opc eq 'REMFOCUS') {
        $x = shift @i;
        return "$x = null";
    } elsif ($opc eq 'NEWFIELD') {
	$x = shift @i;
	$f = shift @i;
	return "$x.+$f";
    } elsif ($opc eq 'NEWFIELDASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$y = shift @i;
	return "$x.+$f = $y";
    } elsif ($opc eq 'NEWVALFIELD') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	return "$x.+$f:$t";
    } elsif ($opc eq 'NEWVALFIELDVALASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$v = shift @i;
#	if ($t eq 'str') {
#	    $v = "\"$v\"";
#	}
	$v = PrintValue($t, $v);
	return "$x.+$f:$t = $v";
    } elsif ($opc eq 'NEWVALFIELDASSIGN') {
	$x = shift @i;
	$f = shift @i;
	$t = shift @i;
	$y = shift @i;
	return "$x.+$f:$t = $y";
    } elsif ($opc eq 'REMFIELD') {
	$x = shift @i;
	$f = shift @i;
	return "$x.-$f";
    } elsif ($opc eq 'ASSIGN') {
	$x = shift @i;
	$y = shift @i;
	return "$x = $y";
    } elsif ($opc eq 'VALASSIGN') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
#	if ($t eq 'str') {
#	    $v = "\"$v\"";
#	}
	$v = PrintValue($t, $v);
	return "$x = $v";
    } elsif ($opc eq 'EQUAL') {
	$x = shift @i;
	$y = shift @i;
	return "$x == $y";
    } elsif ($opc eq 'VALEQUAL') {
	$x = shift @i;
	$v = shift @i;
	$t = shift @i;
#	if ($t eq 'str') {
#	    $v = "\"$v\"";
#	}
	$v = PrintValue($t, $v);
	return "$x == $v";
    } elsif ($opc eq 'MEMBER') {
	$x = shift @i;
	$f = shift @i;
	return "$x/$f";
    } elsif ($opc eq 'REMATOM') {
        $x = shift @i;
        return "rma $x";
    } elsif ($opc eq 'RGC') {
        return "rgc";
    } elsif ($opc eq 'FGC') {
        return "fgc";
    } elsif ($opc eq 'TYPEFIELD') {
	$x = shift @i;
	$t = shift @i;
	if ($t eq 'atom') {
	    $t = "";
	}
	return "$x?$t";
    }
}

1;
