
package GUI;

$VERSION = "0.07";

use Global;

use FileHandle;
use IPC::Open2;

sub Msg {
    my $self = shift;
    my $m = shift;

    $m =~ s/\\/\\\\/g;
    $m =~ s/\n/\\n/g;
    print GOUT "msg($m)\n";
}

sub List {
    my $self = shift;
    my $m = shift;

    $m =~ s/\\/\\\\/g;
    $m =~ s/\n/\\n/g;
    print GOUT "list($m)\n";
}

sub Error {
    my $self = shift;
    my $m = shift;

    $m =~ s/\\/\\\\/g;
    $m =~ s/\n/\\n/g;
    print GOUT "error($m)\n";
}

sub Program {
    my $self = shift;
    my $p = shift;

    print GOUT "program($p)\n";
}

sub SetPC {
    my $self = shift;
    my $pc = shift;

    print GOUT "pc($pc)\n";
}

sub Ack {
    my $self = shift;

    print GOUT "ack\n"
}

sub Quit {
    my $self = shift;

    print GOUT "quit\n"
}

sub CheckStop {
    my $self = shift;
    my $c;
    my $dopr;
    my $ignore = 0;

    #shift;
	if ($#_ == -1 || $_[0] == 0) {
	    $dopr = 1;
	} else {
	    $dopr = 0;
	}
    print GOUT "runcontinue\n";
    while (1) {
    $c = <GIN>;
    chop $c;
#print STDERR "check: $c\n";
    if ($c eq "stop") {
	if ($dopr) {
	    GUI->Msg("stopped\n");
	}
	if ($ignore) {
	    $self->Ack();
	}
	return 1;
    } elsif ($c eq "continue") {
	if ($ignore) {
	    $self->Ack();
	}
	return 0;
    } else {
	# ignore
	$ignore = 1;
    }
    }
}

sub Init {
    $bin = Global::Get('BINDIR');
    if (defined $::thread) {
	$gui = 'threadgui';
    } else {
	$gui = 'gui';
    }
    if (defined $::toolbus) {
	$options = "-NC";
    } else {
	$options = "";
    }
    if ($0 =~ /^.*\/(.*)$/) {
	$s = $1;
    } else {
	$s = $0;
    }
    if (defined $::thread) {
	$s = "threadsim";
    }
    if ($::id ne "") {
	$s .= ":$::id";
    }
    $pid = open2(\*GIN, \*GOUT, "$bin/$gui $options -gn \"$s - $::lang\"");
}

sub ReadCommand {
    my $c;

    $c = <GIN>;
    chop $c;
    if ($c =~ /^\s*(.*\S)\s*$/) {
        $c = $1;
    }
    return $c;
}

sub SetNew {
    my $self = shift;
    my $prim = shift;
    my $p = shift;

    GUI->Program($p);
    $prim->Print(1);
    GUI->SetPC(0);
}

sub FileNoInput {
    return fileno(GIN);
}

1;
