
package Fluid_CG;

$VERSION = "0.00";

use CG;
use FluidValues;

require Exporter;
@ISA = qw( CG Exporter );
@EXPORT = qw( IsFocusName IsReserved IsType HasField GetFocus NewAtom SelectField GetExistLValue GetLValue GetValue GetAtomField SetFocus );
push @EXPORT, @FluidValues::EXPORT;

### Utilities ###

sub IsFocusName {
    my $x = shift;

    if (index($x, '.') == -1) {
	return 1;
    }
    return 0;
}

sub IsReserved {
    my $x = shift;

    if ($x eq 'null' || $x eq 'true' || $x eq 'false') {
        return 1;
    }
    return 0;
}

### end Utilities ###

### Value Access ###

sub IsType {
    my $reg = shift;
    my $type = shift;
    my $false = shift;
    my $s;

    $s = AllocSreg();

    gettype($s, $reg);
    equal_strv($s, "\"$type\"", $false);
    FreeSreg($s);
}

sub HasField {
    my $has = shift;
    my $reg = shift;
    my $f = shift;
    my $false = shift;
    my $l;

    if ($has) {
	fieldexists($reg, $f, $false);
    } else {
	$l = getLocalLabel();
	fieldexists($reg, $f, $l);
	gotolabel($false);
	OutputLabel($l);
    }
}

sub GetFocus {
    my $reg = shift;
    my $x = shift;
    my $false = shift;
    my $else = getLocalLabel();
    my $end = getLocalLabel();

    focusexists($x, $else);
    getfocus($reg, $x);
    gotolabel($end);
    OutputLabel($else);
    getfocus($reg, "null");
    OutputLabel($end);
}

sub NewAtom {
    my $reg = shift;
    my $type = shift;

    newatom($reg);
    settype_v($reg, $type);
}

sub SelectField {
    my $reg = shift;
    my $x = shift;
    my $false = shift;
    my @obj;
    my $a;
    my $f;

    @obj = split('\.', $x);
    $a = shift @obj;
    GetFocus($reg, $a, $false);
    foreach $f (@obj) {
	IsType($reg, "atom", $false);
	HasField(1, $reg, $f, $false);
	getfield($reg, $reg, $f);
    }
}

sub getlvalue {
    my $reg = shift;
    my $x = shift;
    my $t = shift;
    my $false = shift;
    my $p;

    SelectField($reg, $x, $false);
    IsType($reg, $t, $false);
    if ($t eq "atom") {
	$p = AllocPreg();
	getfocus($p, "null");
	notequal($reg, $p, $false);
	FreePreg($p);
    }
}

sub GetExistLValue {
    my $reg = shift;
    my $x = shift;
    my $t = shift;
    my $false = shift;

    if (IsFocusName($x)) {
	GetFocus($reg, $x, $false);
	IsType($reg, $t, $false);
    } else { # field selection
	getlvalue($reg, $x, $t, $false);
    }
}

sub GetLValue {
    my $reg = shift;
    my $x = shift;
    my $t = shift;
    my $false = shift;

    if (IsFocusName($x)) {
	my $else = getLocalLabel();
	my $end = getLocalLabel();
	GetFocus($reg, $x, $else);
	IsType($reg, $t, $else);
	gotolabel($end);
	OutputLabel($else);
	NewAtom($reg, $t);
	setfocus($x, $reg);
	OutputLabel("$end");
    } else { # field selection
	getlvalue($reg, $x, $t, $false);
    }
}

sub GetValue {
    my $reg = shift;
    my $x = shift;
    my $false = shift;

    if (IsFocusName($x)) {
	GetFocus($reg, $x, $false);
    } else {
	SelectField($reg, $x, $false);
    }
}

sub GetAtomField {
    my $reg = shift;
    my $x = shift;
    my $false = shift;
    my @obj;
    my $a;
    my $f;

    @obj = split('\.', $x);
    $a = shift @obj;
    GetFocus($reg, $a, $false);
    $f = shift @obj;
    IsType($reg, "atom", $false);
    HasField(1, $reg, $f, $false);
    while ($#obj >= 0) {
	getfield($reg, $reg, $f);
	$f = shift @obj;
	IsType($reg, "atom", $false);
	HasField(1, $reg, $f, $false);
    }
    return $f;
}

sub SetFocus {
    my $x = shift;
    my $preg = shift;
    my $sreg = shift;
    my $false = shift;
    my $else1 = getLocalLabel();
    my $end1 = getLocalLabel();
    my $else2 = getLocalLabel();
    my $end2 = getLocalLabel();
    my $else3 = getLocalLabel();
    my $end3 = getLocalLabel();
    my $p;
    my $p2;

    equal_strv($sreg, "\"atom\"", $else1);
    setfocus($x, $preg);
    gotolabel($end1);
    OutputLabel($else1);
    focusexists($x, $else2);
    $p = AllocPreg();
    getfocus($p, $x);
    IsType($p, "atom", $end2);
    OutputLabel($else2);
    newatom($p);
    setfocus($x, $p);
    OutputLabel($end2);
    settype($p, $sreg);
    equal_strv($sreg, "\"str\"", $else3);
    $p2 = AllocPreg();
    getvalue($p2, $preg);
    setvalue($p, $p2);
    FreePreg($p2);
    OutputLabel($else3);
    $p2 = AllocPreg();
    getvalue($p2, $preg);
    setvalue($p, $p2);
    FreePreg($p2);
    OutputLabel($end3);
    OutputLabel($end1);
    FreePreg($p);
}

### end Value Access ###

1;
