
package FluidValues;

$VERSION = "0.01";

require Exporter;
@ISA = qw( Exporter );
@EXPORT = qw( %value $types ValueType ProperValue PrintValue );
$value{int} = '[0-9]+';
$value{bool} = 'true|false';
$value{str} = '\".*\"';
$value{any} = "$value{int}|$value{bool}|$value{str}";
$types = "int|bool|str";

sub ValueType {
    my $v = shift;
    my $t;

    if ($v =~ /^$value{int}$/) {
	$t = 'int';
    } elsif ($v =~ /^$value{bool}$/) {
	$t = 'bool';
    } elsif ($v =~ /^$value{str}$/) {
	$t = 'str';
    } else {
	$t = 'unknown';
    }
    return $t;
}

sub ProperValue {
    my $v = shift;
    my $pv;
    my $c;

    if ($v =~ /^\"(.*)\"$/) {
	$v = $1;
	$pv = "";
	while ($v =~ /\\(.)/) {
	    $pv .= $`;
	    $c = $1;
	    $v = $';
	    if ($c eq '\\') {
		$pv .= "\\";
	    } elsif ($c eq '"') {
		$pv .= "\"";
	    } elsif ($c eq 'n') {
		$pv .= "\n";
	    } else {
		$pv .= "\\$c";
	    }
	}
	$pv .= $v;
	return $pv;
    }
    return $v;
}

sub PrintValue {
    my $t = shift;
    my $v = shift;

    if ($t eq 'str') {
	$v =~ s/\\/\\\\/g;
	$v =~ s/\"/\\\"/g;
	$v =~ s/\n/\\n/g;
	return "\"$v\"";
    } else {
	return "$v";
    }
}

1;
