
package FluidGC;

$VERSION = "0.04";

use Global;
use FluidTypes;
use FluidBase;

require Exporter;
@ISA = qw( FluidBase Exporter );
@EXPORT = ( @FluidBase::EXPORT, "RemoveAtom", "RestrictedGC", "FullGC");

sub linked {
    my $x = shift;
    my $nr;
    my $f;
    my $i;

# @link never used, but should be init to ()
    $nr = $focus{$x};
    foreach $f (keys %focus) {
        $link[$focus{$f}] ++;
        if ($f ne $x && $focus{$f} == $nr) {
            return 1;
        }
    }
    for ($i = 0; $i <= $#atom; $i ++) {
        if (%{$atom[$i]}) {
            foreach $f (keys %{$atom[$i]}) {
                if (! ($f eq '_type' || $f eq '_value')) {
                    $link[$atom[$i]{$f}{_value}] ++;
                    if ($atom[$i]{$f}{_value} == $nr) {
                        return 1;
                    }
                }
            }
        }
    }
    return 0;
}

sub RemoveAtom {
    my $x = shift;
    my $nr;
    my $f;

    if (! defined $focus{$x}) {
	return 0;
    } else {
	if (linked($x)) {
	    return 0;
	}
	$nr = $focus{$x};
	SetFocusNull($x);
	foreach $f (keys %{$atom[$nr]}) {
	    if (! ($f eq '_type' || $f eq '_value')) {
		if ($atom[$nr]{$f}{_type} ne 'NONE') {
		    undef $atom[$atom[$nr]{$f}{_value}];
		    SendCommand("delvalfield($nr, $f)");
		} else {
		    SendCommand("delfield($nr, $f)");
		}
	    }
	}
	DelAtom($nr);
	return 1;
    }
}

sub RestrictedGC {
    my $i;
    my $f;

    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]} && $atom[$i]{_type} eq 'NONE') {
#	if (defined %{$atom[$i]}) {
	    $link[$i] = 0;
	} else {
	    $link[$i] = undef;
	}
    }
    foreach $f (keys %focus) {
	$link[$focus{$f}] ++;
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]}) {
	    foreach $f (keys %{$atom[$i]}) {
		if (! ($f eq '_type' || $f eq '_value')) {
		    if ($atom[$i]{$f}{_type} eq 'NONE') {
			$link[$atom[$i]{$f}{_value}] ++;
		    }
#			$link[$atom[$i]{$f}{_value}] ++;
		}
	    }
	}
    }
    $run = 0;
    do {
	$run ++;
	$removed = 0;
	@garbage = ();
	for ($i = 0; $i <= $#atom; $i ++) {
	    if (defined $link[$i] && $link[$i] == 0) {
		push @garbage, $i;
	    }
	}
	foreach $a (@garbage) {
#print STDERR "run $run removing $a\n";
            foreach $f (keys %{$atom[$a]}) {
		if (! ($f eq '_type' || $f eq '_value')) {
		    if ($atom[$a]{$f}{_type} ne 'NONE') {
			undef $atom[$atom[$a]{$f}{_value}];
			undef $link[$atom[$a]{$f}{_value}];
			SendCommand("delvalfield($a, $f)");
		    } else {
			SendCommand("delfield($a, $f)");
			$link[$atom[$a]{$f}{_value}] --;
		    }
		}
            }
	    DelAtom($a);
	    $link[$a] = undef;
	    $removed ++;
	}
# Should disruption of gc be possible?
#	if ($::ui ne 'WebUI') {
#	    if ($::gui) {
#		if (GUI->CheckStop) {
#		    goto ENDRGC;
#		}
#	    } else {
#		if (TUI->CheckStop) {
#		    goto ENDRGC;
#		}
#	    }
#	}
    } while ($removed);
ENDRGC:
}

sub reach {
    my $a = shift;
    my $f;

    if ($reached[$a]) {
	return;
    }
    $reached[$a] = 1;
    foreach $f (keys %{$atom[$a]}) {
	if (! ($f eq '_type' || $f eq '_value')) {
	    if ($atom[$a]{$f}{_type} eq 'NONE') {
		reach($atom[$a]{$f}{_value});
	    }
#		reach($atom[$a]{$f}{_value});
	}
    }
}

sub FullGC {
    my $i;
    my $f;
    my $a;

    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]} && $atom[$i]{_type} eq 'NONE') {
#	if (defined %{$atom[$i]}) {
	    $reached[$i] = 0;
	} else {
	    $reached[$i] = undef;
	}
	$deleted[$i] = 0;
    }
    foreach $f (keys %focus) {
	$a = $focus{$f};
	reach($a);
    }
    # first delete all fields and then the atoms, otherwise problems with fluid
    for ($i = 0; $i <= $#atom; $i ++) {
	if (defined $reached[$i] && $reached[$i] == 0) {
            foreach $f (keys %{$atom[$i]}) {
		if (! ($f eq '_type' || $f eq '_value')) {
		    if ($atom[$i]{$f}{_type} ne 'NONE') {
			undef $atom[$atom[$i]{$f}{_value}];
			undef $reached[$atom[$i]{$f}{_value}];
			SendCommand("delvalfield($i, $f)");
		    } else {
			SendCommand("delfield($i, $f)");
		    }
		}
            }
	    $deleted[$i] = 1;
	}
# Should disruption of gc be possible?
#	if ($::ui ne 'WebUI') {
#	    if ($::gui) {
#		if (GUI->CheckStop) {
#		    last;
#		}
#	    } else {
#		if (TUI->CheckStop) {
#		    last;
#		}
#	    }
#	}
    }
    for ($i = 0; $i <= $#atom; $i ++) {
        if (! defined $reached[$i]) {
            next;
        }
        if ($deleted[$i]) {
            next;
        }
        foreach $f (keys %{$atom[$i]}) {
            if ($f eq '_type' || $f eq '_value') {
                next;
            }
            if ($atom[$i]{$f}{_type} ne 'NONE') {
                next;
            }
            if ($deleted[$atom[$i]{$f}{_value}]) {
		SendCommand("delfield($i, $f)");
                delete $atom[$i]{$f};
            }
        }
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (defined $reached[$i] && $reached[$i] == 0 && $deleted[$i]) {
	    DelAtom($i);
	}
    }
}

1;
