
package FluidBase;

$VERSION = "0.10";

use Global;
use FluidTypes;
use FluidValues;

require Exporter;
@ISA = qw( FluidTypes FluidValues Exporter );
@EXPORT = qw( IsFocusName HasField IsType IsFieldType Equal DefaultValue SetFocusNull GetValue GetType GetFieldType NewFocus RemoveFocus SetFocusValue SetFocus GetFocus SetField SetFieldValue SetFieldNew GetField AddField DelField AddValueField DelValueField NewAtom NewAtomValue DelAtom SendCommand );

sub IsFocusName {
    my $object = shift;

    if (index($object, '.') == -1) {
	return 1;
    } else {
	return 0;
    }
}

sub HasField {
    my $a = shift;
    my $f = shift;

    return defined $atom[$a]{$f};
}

sub IsType {
    my $a = shift;
    my $t = shift;

    return $atom[$a]{_type} eq $t;
}

sub IsFieldType {
    my $a = shift;
    my $f = shift;
    my $t = shift;

    return $atom[$a]{$f}{_type} eq $t;
}

sub Equal {
    my $ax = shift;
    my $ay = shift;
    my $t;

    if ($ax == $ay) {
	return 1;
    }
    $t = GetType($ax);
    if (! IsType($ay, $t)) {
	return 0;
    }
    if ($t eq 'NONE') {
	return $ax == $ay;
    } elsif ($t eq 'int') {
	return GetValue($ax) == GetValue($ay);
    } else {
	return GetValue($ax) eq GetValue($ay);
    }
}

sub DefaultValue {
    my $t = shift;

    return $deftype{$t};
}

sub SetFocusNull {
    my $x = shift;

    if (defined $::nonull) {
        if (defined $focus{$x}) {
            delete $focus{$x};
	    SendCommand("remfocus($x)");
        }
    } else {
        $focus{$x} = $focus{null};
	SendCommand("setfocus($x, null)");
    }
}

sub GetValue {
    my $a = shift;

    return $atom[$a]{_value};
}

sub GetType {
    my $a = shift;

    return $atom[$a]{_type};
}

sub GetFieldType {
    my $a = shift;
    my $f = shift;

    return $atom[$a]{$f}{_type};
}

sub NewFocus {
    my $x = shift;
#print STDERR "focusnew: $x\n";

    if (defined $focus{$x} && ! IsType($focus{$x}, 'NONE')) {
	SendCommand("remfocus($x)");
	DelAtom($focus{$x});
    } else {
	$focus{$x} = $nratoms;
	$nratoms ++;
    }
    $atom[$focus{$x}]{_type} = 'NONE';
    $atom[$focus{$x}]{_value} = 'NULL';
    SendCommand("new($x, $focus{$x})");
    return $focus{$x};
}

sub RemoveFocus {
    my $x = shift;
    my $nr;

    if (defined $focus{$x}) {
	$nr = $focus{$x};
    } else {
	$nr = -1;
    }
    SetFocusNull($x);
    if ($nr != -1) {
	if (! IsType($nr, 'NONE')) {
	    DelAtom($nr);
	}
    }
}

sub SetFocusValue {
    my $x = shift;
    my $t = shift;
    my $v = shift;
    my $a;

    if (! defined $focus{$x} || IsType($focus{$x}, 'NONE')) {
	$focus{$x} = $nratoms;
	$nratoms ++;
    }
    $a = $focus{$x};
    $atom[$a]{_type} = $t;
    $atom[$a]{_value} = $v;
    $v = PrintValue($t, $v);
    SendCommand("setvalfocus($x, $v, $a)");
}

sub SetFocus {
    my $x = shift;
    my $ay = shift;

#print STDERR "setfocus: $x $ay\n";
    if ($atom[$ay]{_type} ne 'NONE') {
	SetFocusValue($x, GetType($ay), GetValue($ay));
    } else {
	if (defined $focus{$x} && ! IsType($focus{$x}, 'NONE')) {
	    SendCommand("remfocus($x)");
	    DelAtom($focus{$x});
	}
	if ($ay == 0) { # ---.f == null
	    SetFocusNull($x);
	} else {
	    $focus{$x} = $ay;
	    SendCommand("setfocus($x, $ay)");
	}
    }
    return $focus{$x};
}

sub GetFocus {
    my $x = shift;

    if ($x eq 'null') {
	return 0;
    }
    if (defined $focus{$x}) {
	return $focus{$x};
    } else {
	return 0; # null
    }
}

sub SetField {
    my $ax = shift;
    my $f = shift;
    my $ay = shift;
#print STDERR "setfield: $ax $f $ay\n";

    if (! HasField($ax, $f)) {
	# should not be done here
	AddField($ax, $f);
    }
    $atom[$ax]{$f}{_type} = 'NONE';
    $atom[$ax]{$f}{_value} = $ay;
    if ($ay == 0) { # null
	SendCommand("setfield($ax, $f, null)");
    } else {
	SendCommand("setfield($ax, $f, $ay)");
    }
}

sub SetFieldValue {
    my $ax = shift;
    my $f = shift;
    my $t = shift;
    my $v = shift;

    $atom[GetField($ax,$f)]{_value} = $v;
    $v = PrintValue($t, $v);
    SendCommand("setvalfield($ax, $f, $v)");
}

sub SetFieldNew {
    my $ax = shift;
    my $f = shift;
    my $ay;

    $ay = NewAtomValue('NONE', 'NULL');
    if (! HasField($ax, $f)) {
	AddField($ax, $f);
    }
    $atom[$ax]{$f}{_value} = $ay;
    SendCommand("setfieldnew($ax, $f, $ay)");
}

sub GetField {
    my $a = shift;
    my $f = shift;

    return $atom[$a]{$f}{_value};
}

sub AddField {
    my $a = shift;
    my $f = shift;
#print STDERR "AddField: $a $f\n";

    $atom[$a]{$f}{_type} = 'NONE';
    $atom[$a]{$f}{_value} = $a;
    SendCommand("addfield($a, $f)");
}

sub DelField {
    my $a = shift;
    my $f = shift;

    delete $atom[$a]{$f};
    SendCommand("delfield($a, $f)");
}

sub AddValueField {
    my $a = shift;
    my $f = shift;
    my $t = shift;
    my $v = shift;
    my $na;
#print STDERR "addvalfield: $a $f $t $v\n";

    $na = NewAtomValue($t, $v);
    $atom[$a]{$f}{_type} = $t;
    $atom[$a]{$f}{_value} = $na;
    $v = PrintValue($t, $v);
    SendCommand("addvalfield($a, $f, $t, $v, $na)");
}

sub DelValueField {
    my $a = shift;
    my $f = shift;

    undef $atom[$atom[$a]{$f}{_value}];
    delete $atom[$a]{$f};
    SendCommand("delvalfield($a, $f)");
}

sub NewAtom {
    my $a;

    $a = $nratoms ++;
    return $a;
}

sub NewAtomValue {
    my $t = shift;
    my $v = shift;
    my $a;

    $a = NewAtom();
    $atom[$a]{_type} = $t;
    $atom[$a]{_value} = $v;
    return $a;
}

sub DelAtom {
    my $nr = shift;

    $atom[$nr] = undef;
    SendCommand("rematom($nr)");
}

sub DumpFluid {
    my $self = shift;
    my $f;
    my $i;
    my $v;

    print "foci:\n";
    foreach $f (keys %focus) {
	print "    $f    $focus{$f}\n";
    }
    print "atoms:\n";
    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]}) {
	    print "    $i\n";
	    if ($atom[$i]{_type} eq 'NONE') {
		foreach $f (keys %{$atom[$i]}) {
		    if (! ($f eq '_type' || $f eq '_value')) {
			print "        $f ";
			$v = $atom[$i]{$f}{_value};
			if ($atom[$i]{$f}{_type} ne 'NONE') {
			    print ": $atom[$i]{$f}{_type} ";
#			    $v = PrintValue($atom[$i]{$f}{_type}, $v);
			}
			print "-> $v";
			print "\n";
		    }
		}
	    } else {
#		if ($atom[$i]{_type} eq 'str') {
#		    $v = "\"$atom[$i]{_value}\"";
#		} else {
#		    $v = $atom[$i]{_value};
#		}
		$v = PrintValue($atom[$i]{_type}, $atom[$i]{_value});
		print "        $v : $atom[$i]{_type}\n";
	    }
	}
    }
#    if (defined $::coreview) {
#       print FLUID "dump\n";
#       while (<ACK>) {
#           if (/^ack$/) {
#               last;
#           }
#           print $_;
#       }
#    }
}

sub GenDot {
    my $self = shift;
    my $filename = shift;

    open(FH, ">$filename");
    print FH "digraph graph0 {\n";
    print FH "    bgcolor=white;\n";
    print FH "    node [label=\"\\N\", shape=circle, height=\"0.1\", fixedsize=true, fontsize=12];\n";
    print FH "    edge [dir=forward, arrowsize=\"0.8\", fontsize=14];\n";
    print FH "    graph [rankdir=LR];\n";

    $nodenr = 0;
    foreach $f (keys %focus) {
	if ($f eq 'null') {
	    next;
	}
	if ($focus{$f} == $focus{null}) {
	    next;
	}
	print FH "    n$nodenr [label=\"\", style=invis];\n";
	$nodenr ++;
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if ($i == $focus{null}) {
	    next;
	}
	if (%{$atom[$i]}) {
	    if ($atom[$i]{_type} eq 'NONE') {
		$n = $i + $nodenr;
		print FH "    n$n [label=\"\", style=filled, color=black];\n";
	    } else {
		$n = $i + $nodenr;
		print FH "    n$n [label=\"$atom[$i]{_value}\", style=unfilled, fontcolor=red4, shape=plaintext, width=0, fixedsize=false];\n";
	    }
	}
    }
    $n1 = 0;
    $null = 0;
    foreach $f (keys %focus) {
	if ($f eq 'null') {
	    next;
	}
	if ($focus{$f} == $focus{null}) {
	    next;
	}
	$n2 = $focus{$f} + $nodenr;
	print FH "    n$n1 -> n$n2 [label=\"$f\", color=blue, fontcolor=blue, weight=4];\n";
	$n1 ++;
    }
    for ($i = 0; $i <= $#atom; $i ++) {
	if (%{$atom[$i]}) {
	    if ($atom[$i]{_type} eq 'NONE') {
		$n1 = $i + $nodenr;
		foreach $f (keys %{$atom[$i]}) {
		    if (! ($f eq '_type' || $f eq '_value')) {
			$v = $atom[$i]{$f}{_value};
			if ($atom[$i]{$f}{_type} eq 'NONE') {
			    if ($atom[$i]{$f}{_value} == $focus{'null'}) {
				print FH "    null$null [label=\"\", style=unfilled];\n";
				$n2 = "ull$null";
				$null ++;
			    } else {
				$n2 = $v + $nodenr;
			    }
			    print FH "    n$n1 -> n$n2 [label=\"$f\"];\n";
			} else {
			    $n2 = $v + $nodenr;
			    print FH "    n$n1 -> n$n2 [label=\"$f:$atom[$i]{$f}{_type}\", color=red4, fontcolor=red4];\n";
			}
		    }
		}
	    }
	}
    }

    print FH "}\n";
    close FH;
}

use FileHandle;
use IPC::Open2;

sub stop {
    print FLUID "quit\n";
    exit;
}

sub InitFluid {
    my $bin;
    my $pid;

    undef %focus;
    undef @atom;
    $nratoms = 0;
    if (defined $::coreview) {
	if (! fileno FLUID) {
	    $SIG{INT} = 'IGNORE';
	    $bin = Global::Get('BINDIR');
	    # using global variable $::bi - UGLY
	    $pid = open2(\*ACK, \*FLUID, "$bin/fluidint $::fluidoptions -b $::bi");
	    $SIG{INT} = \&stop;
	} else {
	    print FLUID "reset\n";
	    $ack = <ACK>;
	}
    }
    # add the null
    $focus{null} = NewAtomValue('NONE', 'NULL');
    if (! defined $::nonull) {
	SendCommand("new(null, $focus{null})");
    }
}

$coreviewupdate = 1;

sub SetUpdate {
    my $self = shift;
    my $update = shift;

    $coreviewupdate = $update;
    SendCommand("doupdates($update)");
}

sub Update {

    if ($coreviewupdate == 0) {
	SendCommand("update");
    }
}

sub SendCommand {
    my $comm = shift;

    if (defined $::coreview) {
	print FLUID "$comm\n";
	$ack = <ACK>;
    }
}

END {
    if (defined $::coreview) {
	if (fileno FLUID) {
	    print FLUID "quit\n";
	}
    }
}

1;
