
namespace eval Fluid {
    variable nodenr
    variable focus
    variable node
    variable edge
    variable atom
    variable fontsize
    variable color
    variable doupdates 1

    set color(focus) blue
    set color(value) red4

    package provide Fluid 0.15
    package require Tcldot
}

proc Fluid::FontSize {fs} {
    variable fontsize

    set fontsize $fs
}

proc Fluid::Init {} {
    variable nodenr 0
    global c g
    variable fontsize

    set g [dotnew digraph rankdir LR]

#    $g setnodeattributes shape circle height 0.1 style filled color black fixedsize true fontsize $fontsize
    $g setnodeattributes shape circle height 0.1 fixedsize true fontsize $fontsize
    $g setedgeattributes dir forward arrowsize 0.8 fontsize $fontsize

    Fluid::_update
}

proc Fluid::Reset {} {
    variable node
    variable nodenr
    variable focus
    variable edge
    variable atom
    global c g

    set nodenr 0
    if {[array exists node]} {
	array unset node *
    }
    if {[array exists focus]} {
	array unset focus *
    }
    if {[array exists edge]} {
	array unset edge *
    }
    if {[array exists atom]} {
	array unset atom *
    }
    $g delete
    update

    Fluid::Init
}

proc Fluid::_update {} {
    variable doupdates

    if {$doupdates == 1} {
	Fluid::Update
    }
}

proc Fluid::SetUpdate {u} {
    variable doupdates

    set doupdates $u
}

proc Fluid::Update {} {
    global c g

    $c delete all
    $g layout
    eval [$g render]
    update
    set bbox [$c bbox all]
    if {$bbox == {}} {
	set bbox {0 0 0 0}
    } else {
	set bbox "0 0 [expr [lindex $bbox 2] + [lindex $bbox 0]] [expr [lindex $bbox 3] + [lindex $bbox 1]]"
    }
    $c configure -scrollregion $bbox
}

proc is_focus { x } {
    if {[regexp "^\[0-9\]*$" $x match]} {
	return 0
    } else {
	return 1
    }
}

proc is_null { n } {
    if {[lindex [$n queryattributes style] 0] == "unfilled"} {
	return 1
    } else {
	return 0
    }
}

proc Fluid::AddNode { f } {
    variable nodenr
    global g

    incr nodenr
    if {$f == 2} {
	return [$g addnode n$nodenr label "" style invis]
    } elseif {$f == 1} {
	return [$g addnode n$nodenr label "" group 2 style filled color black]
    } else {
	return [$g addnode n$nodenr label "" style unfilled fillcolor lightgray]
    }
# ?    Fluid::_update
}

proc Fluid::DelNode { f } {
    $f delete
}

proc Fluid::AddValue { v n } {
    variable nodenr
    variable color
    global g
    variable atom

    incr nodenr
    set atom($n) [$g addnode n$nodenr label "$v" shape plaintext width 0 fixedsize false fontcolor $color(value) style unfilled]
    return $atom($n)
}

proc Fluid::AddEdge { n1 n2 l f } {
    variable color
    global g

    if { $f } {
	if { $f == 2 } {
	    set e [$g addedge $n1 $n2 label $l color $color(value) fontcolor $color(value) weight 4]
	} else {
	    set e [$g addedge $n1 $n2 label $l color $color(focus) fontcolor $color(focus) weight 4]
	}
    } else {
	set e [$g addedge $n1 $n2 label $l]
    }
    return $e
}

proc Fluid::DelEdge { h } {
    $h delete
}

proc Fluid::AddFocus { x n } {
    variable focus
    variable edge
    variable atom
    
    if { [info exists focus($x,1)] } {
	Fluid::DelEdge $edge($focus($x,1),$x)
    } else {
	set focus($x,1) [Fluid::AddNode 2]
    }
    if {$x == "null"} { # add the null
	set atom($n) [Fluid::AddNode 0]
    } else {
    set atom($n) [Fluid::AddNode 1]
    }
    set focus($x,2) $atom($n)
    set edge($focus($x,1),$x) [Fluid::AddEdge $focus($x,1) $focus($x,2) $x 1]
    Fluid::_update
}

proc Fluid::DelFocus { x } {
    variable focus
    variable edge
    variable node

    Fluid::DelEdge $edge($focus($x,1),$x)
    $focus($x,1) delete
    unset edge($focus($x,1),$x)
    unset focus($x,1)
    unset focus($x,2)
    Fluid::_update
}

proc Fluid::AddField { x f } {
    variable focus
    variable atom
    variable edge
    variable node

    if {[is_focus $x]} {
	set a $focus($x,2)
    } else {
	set a $atom($x)
    }
    set node($a,$f) $a
    set edge($a,$f) [Fluid::AddEdge $a $a $f 0]
    Fluid::_update
}

proc Fluid::AddValField { x f t v n } {
    variable focus
    variable atom
    variable edge
    variable node

    if {[is_focus $x]} {
	set a $focus($x,2)
    } else {
	set a $atom($x)
    }
    regsub -all {\\} $v {\\\\} v
    set node($a,$f) [Fluid::AddValue $v $n]
    set edge($a,$f) [Fluid::AddEdge $a $node($a,$f) "$f:$t" 2]
    Fluid::_update
}

proc Fluid::DelField { x f } {
    variable focus
    variable edge
    variable node
    variable atom

    if {[is_focus $x]} {
	set n $focus($x,2)
    } else {
	set n $atom($x)
    }
    Fluid::DelEdge $edge($n,$f)
    if {[is_null $node($n,$f)]} {
	Fluid::DelNode $node($n,$f)
    }
    unset node($n,$f)
    unset edge($n,$f)
    Fluid::_update
}

proc Fluid::DelValField { x f } {
    variable focus
    variable edge
    variable node
    variable atom

    if {[is_focus $x]} {
	set n $focus($x,2)
    } else {
	set n $atom($x)
    }
    Fluid::DelEdge $edge($n,$f)
    Fluid::DelNode $node($n,$f)
    unset node($n,$f)
    unset edge($n,$f)
    Fluid::_update
}

proc Fluid::SelField { x y f} {
    variable focus
    variable edge
    variable node

    if {! [info exists focus($x,1)] } {
	set focus($x,1) [Fluid::AddNode 2]
    } else {
	if { $focus($x,2) != "null" } {
	    Fluid::DelEdge $edge($focus($x,1),$x)
	}
    }
    set focus($x,2) $node($focus($y,2),$f)
    set edge($focus($x,1),$x) [Fluid::AddEdge $focus($x,1) $focus($x,2) $x 1]
    Fluid::_update
}

proc Fluid::SetFocus { x y } {
    variable focus
    variable atom
    variable edge

    if {! [info exists focus($x,1)] } {
	set focus($x,1) [Fluid::AddNode 2]
    } else {
	if { $focus($x,2) != "null" } {
	    Fluid::DelEdge $edge($focus($x,1),$x)
	}
    }
    if {[is_focus $y]} {
	set ay $focus($y,2)
    } else {
	set ay $atom($y)
    }
    set focus($x,2) $ay
    set edge($focus($x,1),$x) [Fluid::AddEdge $focus($x,1) $focus($x,2) $x 1]
    Fluid::_update
}

proc Fluid::SetValFocus { x v n } {
    variable focus
    variable edge

    if {! [info exists focus($x,1)] } {
	set focus($x,1) [Fluid::AddNode 2]
    }
    regsub -all {\\} $v {\\\\} v
    if {[info exists focus($x,2)]} {
	if {[lindex [$focus($x,2) queryattributes label] 0] == ""} {
	    # there should be a better way to decide this
	    Fluid::DelEdge $edge($focus($x,1),$x)
	    set focus($x,2) [Fluid::AddValue $v $n]
	    set edge($focus($x,1),$x) [Fluid::AddEdge $focus($x,1) $focus($x,2) $x 1]
	} else {
	    $focus($x,2) setattributes label $v
	}
    } else {
	set focus($x,2) [Fluid::AddValue $v $n]
	set edge($focus($x,1),$x) [Fluid::AddEdge $focus($x,1) $focus($x,2) $x 1]
    }
    Fluid::_update
}

proc Fluid::SetField { x f y } {
    variable focus
    variable atom
    variable edge
    variable node

    if {[is_focus $x]} {
	set ax $focus($x,2)
    } else {
	set ax $atom($x)
    }
    if {[is_focus $y]} {
	if {$y == "null"} {
	    set ay [Fluid::AddNode 0]
	} else {
	    set ay $focus($y,2)
	}
    } else {
	set ay $atom($y)
    }
    Fluid::DelEdge $edge($ax,$f)
    if {[is_null $node($ax,$f)]} {
	Fluid::DelNode $node($ax,$f)
    }
    set node($ax,$f) $ay
    set edge($ax,$f) [Fluid::AddEdge $ax $ay $f 0]
    Fluid::_update
}

proc Fluid::SetFieldNew { a f n } {
    variable atom
    variable edge
    variable node

    Fluid::DelEdge $edge($atom($a),$f)
    if {[is_null $node($atom($a),$f)]} {
	Fluid::DelNode $node($atom($a),$f)
    }
    set atom($n) [Fluid::AddNode 1]
    set node($atom($a),$f) $atom($n)
    set edge($atom($a),$f) [Fluid::AddEdge $atom($a) $atom($n) $f 0]
    Fluid::_update
}

proc Fluid::SetValField { x f v } {
    variable focus
    variable atom
    variable edge
    variable node

    if {[is_focus $x]} {
	set ax $focus($x,2)
    } else {
	set ax $atom($x)
    }
    $node($ax,$f) setattributes label $v
    Fluid::_update
}

proc Fluid::DelAtom { a } {
    variable atom

    Fluid::DelNode $atom($a)
    unset atom($a)
    Fluid::_update
}

proc Fluid::Dump {} {
    variable node
    variable edge
    variable atom

#    parray Fluid::node *
#    parray Fluid::edge *
#    parray Fluid::atom *
    set el [array names node *]
    foreach e $el {
	puts "node($e) = $node($e)"
    }
    set el [array names edge *]
    foreach e $el {
	puts "edge($e) = $edge($e)"
    }
    set el [array names atom *]
    foreach e $el {
	puts "atom($e) = $atom($e)"
    }
}
