
package FMNcore;

$VERSION = "0.03";

use Global;

sub load_focus {
    my $f = shift;

    if ($loaded{$f}) {
	return 1;
    } else {
#	if (! eval {require "$f.pm"}) {
#	    return 0;
#	}
	ITER: {
	    foreach $l (@COLIB) {
		$filename = "$l/$f.pm";
		if (-f $filename) {
		    $result = eval `cat $filename`;
		    last ITER;
		}
	    }
	    print STDERR "no module '$f.pm' found in ", join(", ", @COLIB), "\n";
	    return 0;
	}
	if ($@) {
	    print STDERR "error on loading '$filename'\n";
	    return 0;
	}
	if (! $result) {
	    print STDERR "error found in '$filename'\n";
	    return 0;
	}
	$loaded{$f} = 1;
	return 1;
    }
}

sub focus_has_method {
    my $f = shift;
    my $m = shift;
    my $s;

    $s = "${f}::$m";
    if (defined &{$s}) {
	return 1;
    } else {
	return 0;
    }
}

sub call {
    my $f = shift;
    my $m = shift;
    my $a = shift;
    my $r;

    $r = $f->$m(split("\s*,\s*", $a));
    return $r;
}

sub prefixcall {
    my $f = shift;
    my $o = shift;
    my $m = shift;
    my $a = shift;
    my $r;

    if (! defined $prefix{$f}{$o}) {
	if (! ($prefix{$f}{$o} = $f->new(($o eq "") ? "<>" : $o))) {
print STDERR "no prefix '$f.$o' can be made\n";
	    return 0;
	}
    }
    $rf = $prefix{$f}{$o};
    $r = call($rf, $m, $a);
    return $r;
}

sub Exec {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $f;
    my $o;
    my $m;
    my $a;

    $opc = shift @i;
    if ($opc eq 'METHODCALL') {
	$f = shift @i;
	$m = shift @i;
	$a = shift @i;
	if (load_focus($f)) {
	    if (focus_has_method($f, $m)) {
		$r = prefixcall($f, "", $m, $a);
		return $r;
	    } else {
		return 0;
	    }
	} else {
	    return 0;
	}
    } elsif ($opc eq 'PREFIXMETHODCALL') {
	$f = shift @i;
	$o = shift @i;
	$m = shift @i;
	$a = shift @i;
	if (load_focus($f)) {
	    if (focus_has_method($f, $m)) {
		$r = prefixcall($f, $o, $m, $a);
		return $r;
	    } else {
		return 0;
	    }
	} else {
	    return 0;
	}
    }
}

use SMView;

sub InitCore {
    my $lib;
    my $l;

    # libraries for co-programs
    $lib = Global::Get('LIBDIR');
    $lib .= "/coprog";
    @COLIB = ($lib);
    foreach $l (@::colibrary) {
	unshift(@COLIB, $l);
    }
    %prefix = ();
    SMView::Init(join(" ", @COLIB));
}

sub DumpCore {
    my $f;
    my $o;

    foreach $f (keys %prefix) {
	foreach $o (keys %{$prefix{$f}}) {
	    $s = "${f}::dump";
	    if (defined &{$s}) {
		call($prefix{$f}{$o}, "dump", "");
	    }
	}
    }
}

sub SetUpdate {
}

sub Update {
}

1;
