
package FMN;

$VERSION = "0.02";

use Global;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
        die "module BI_TB not found\n";
    }
    @ISA = qw( BI_TB );
} else {
    if (! eval {require "FMNcore.pm"}) {
        die "module FMNcore not found\n";
    }
    @ISA = qw( FMNcore );
}

$id = '[a-zA-Z][a-zA-Z0-9]*';
$arg = '[a-zA-Z0-9]*';
$methodarg = '[a-zA-Z0-9 ]*';

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^($id)\.($id)\((.*)\)$/) {
	@prim = ( 'METHODCALL', $1, $2, $3 );
    } elsif ($i =~ /^($id)\.($id):($id)\((.*)\)$/) {
	@prim = ( 'PREFIXMETHODCALL', $1, $2, $3, $4 );
#    } elsif ($i =~ /^($id)((:($arg))?)\.($id)((:($methodarg))?)$/) {
    } elsif ($i =~ /^($id)((:($arg))?)\.($id)((:(.*))?)$/) {
	if ($4 eq "") {
	    @prim = ('METHODCALL', $1, $5, $8 );
	} else {
	    @prim = ('PREFIXMETHODCALL', $1, $4, $5, $8 );
	}
    } else {
	@prim = ( 'ERROR' );
    }
    return @prim;
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $f;
    my $o;
    my $m;
    my $a;

    $opc = shift @i;
    if ($opc eq 'METHODCALL') {
	$f = shift @i;
	$m = shift @i;
#	$a = shift @i;
#	return "$f.$m($a)";
	$a = join(":", @i);
	return "$f.$m:$a";
    } elsif ($opc eq 'PREFIXMETHODCALL') {
	$f = shift @i;
	$o = shift @i;
	$m = shift @i;
#	$a = shift @i;
#	return "$f.$o:$m($a)";
	$a = join(":", @i);
	return "$f:$o.$m:$a";
    }
}

1;
