
package ExtendedFocus;

$VERSION = "0.00";

use Global;
use FluidTypes;
use FluidBase;

require Exporter;
@ISA = qw( FluidBase FluidTypes Exporter );
@EXPORT = qw( ExtendedFocus ExtendedFocusTypedValue ExtendedFocusValue );

sub ExtendedFocus {
    my $object = shift;
    my @obj;
    my $x;
    my $a;
    my $f;

    @obj = split('\.', $object);
    $x = shift @obj;
    if (defined $focus{$x}) {
	$a = $focus{$x};
	$f = shift @obj;
	if (HasField($a, $f)) {
	    while ($#obj >= 0) {
		if (! IsFieldType($a, $f, 'NONE')) {
		    return (-1, -1);
		}
		$a = GetField($a, $f);
		$f = shift @obj;
		if (! HasField($a, $f)) {
		    return (-1, -1);
		}
	    }
	    return ($a, $f);
	} else {
	    return (-1, -1);
	}
    } else {
	return (-1, -1);
    }
}

sub ExtendedFocusTypedValue {
    my $y = shift;
    my $t = shift;

    if (IsFocusName($y)) {
	if (! defined $focus{$y}) {
	    return undef;
	}
	$ay = $focus{$y};
	if (! IsType($ay, $t)) {
	    return undef;
	}
    } else {
	($ay, $fy) = ExtendedFocus($y);
	if ($ay == -1) {
	    return undef;
	}
	if (! IsFieldType($ay, $fy, $t)) {
	    return undef;
	}
	$ay = GetField($ay, $fy);
    }
    return $ay;
}

sub ExtendedFocusValue {
    my $y = shift;
    my $ay;

    if (IsFocusName($y)) {
	if (! defined $focus{$y}) {
	    return undef;
	}
	$ay = $focus{$y};
    } else {
	($ay, $fy) = ExtendedFocus($y);
	if ($ay == -1) {
	    return undef;
	}
	$ay = GetField($ay, $fy);
    }
    return $ay;
}

1;
