
package Directive;

$VERSION = "0.00";

use Breakpoint;
@ISA = qw( Breakpoint );

sub Init {
    my $self = shift;
    $input = shift;
    $action = shift;
    $ui = shift;
    $action->InitCore;
}

$name ="[a-zA-Z][a-zA-Z0-9]*";
$lname ="($name)?(:$name)*";

sub Parse {
    my $self = shift;
    my $verbose = shift;
    my $i;
    my $ic;
    my @basic;
    my $error;

    undef @prog;
    $ic = 0;
    $i = $input->Next;
    $error = 0;
    while (defined $i) {
	if ($verbose) {
	    $ui->Msg(" $ic");
	}
	if ($i =~ /^(\s*)\.namespace ($name)$/) {
	    $prog[$ic ++] = [( 'NAMESPACE', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.end$/) {
	    $prog[$ic ++] = [( 'END', $1 )];
	} elsif ($i =~ /^(\s*)\.label ($name)$/) {
	    $prog[$ic ++] = [( 'LABEL', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.goto ($name)$/) {
	    $prog[$ic ++] = [( 'GOTO', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.goto ($lname)$/) {
	    $prog[$ic ++] = [( 'GOTO', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.call ($name)$/) {
	    $prog[$ic ++] = [( 'CALL', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.call ($lname)$/) {
	    $prog[$ic ++] = [( 'CALL', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.return$/) {
	    $prog[$ic ++] = [( 'RETURN', $1 )];
	} elsif ($i =~ /^(\s*)\.comment (.*)$/) {
	    $prog[$ic ++] = [( 'COMMENT', $2, $1 )];
	} elsif ($i =~ /^(\s*)\.\# (.*)$/) {
	    $prog[$ic ++] = [( 'COMMENT', $2, $1 )];
	} else {
	#    @basic = $action->Parse($i);
	#    $prog[$ic ++] = [( 'ACTION', @basic )];
	    $prog[$ic ++] = [( 'ACTION', $i )];
	}
        if ($basic[0] eq 'ERROR') {
            $error ++;
            @basic = ();
        }
	$i = $input->Next;
    }
    &reset;
    $self->ClearBreakpoints;
    return $error;
}

sub indent {
    my $indent = shift;
    my $j;
    my $s;

    $s = "";
    for ($j = 0; $j < $indent; $j ++) {
	$s .= "    ";
    }
    return $s;
}

sub PrintStep {
    my $self = shift;
    my $attr = shift;
    my @i = @_;
    my $opc;
    my $l;
    my $n;
    my $s;

    $opc = shift @i;
    if ($opc eq 'ACTION') {
	$s = $action->Print(@i);
    } elsif ($opc eq 'NAMESPACE') {
	$l = shift @i;
	$s = shift @i;
	return "$s.namespace $l";
    } elsif ($opc eq 'END') {
	$s = shift @i;
	return "$s.end";
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	$s = shift @i;
	return "$s.label $l";
    } elsif ($opc eq 'GOTO') {
	$l = shift @i;
	$s = shift @i;
	return "$s.goto $l";
    } elsif ($opc eq 'LGOTO') {
	$l = shift @i;
	$s = shift @i;
	return "$s.goto $l";
    } elsif ($opc eq 'CALL') {
	$l = shift @i;
	$s = shift @i;
	return "$s.call $l";
    } elsif ($opc eq 'RETURN') {
	$s = shift @i;
	return "$s.return";
    } elsif ($opc eq 'COMMENT') {
	$l = shift @i;
	$s = shift @i;
	return "$s.comm $l";
    }
}

sub Print {
    my $self = shift;
    my $attr = shift;
    my @i;
    my $ic;
    my $opc;
    my $indent = 1;
    my $s;

    for ($ic = 0; $ic <= $#prog; $ic ++) {
	$s = "";
	if ($attr) {
	    $s .= sprintf "%3d ", $ic;
	}
	@i = @{$prog[$ic]};
	$opc = shift @i;
	unshift @i, $opc;
	if ($attr) {
	    if ($opc eq 'ACTION') {
		$s .= indent($indent);
	    }
	}
	$s .= $self->PrintStep($attr, @i);
	$ui->List("$s\n");
    }
}

sub Check {
    my $self = shift;
    my $ic;
    my @i;
    my $opc;
    my $l;
    my @ni;
    my $nopc;

}

sub reset {
    $pc = 0;
}

sub InitCore {
    my $self = shift;
    $action->InitCore;
}

sub DumpCore {
    my $self = shift;
    $action->DumpCore;
}

sub Mem {
    return \@prog;
}

sub Action {
    return $action;
}

1;
