
package CIL;

$VERSION = "0.00";

require Exporter;
@ISA = qw( Exporter);
@EXPORT = qw (
    AllocPreg FreePreg AllocIreg FreeIreg AllocSreg FreeSreg
    getInstrLabel getLocalLabel
    OutputComment OutputPre OutputPost OutputInstr OutputLabel
    newatom
    getfield setfield removefield fieldexists
    gettype settype settype_v
    getvalue setvalue
    getvalue_int setvalue_int setvalue_intv
    getvalue_str setvalue_str setvalue_strv
    getfocus setfocus removefocus focusexists
    equal notequal equal_str equal_strv equal_int equal_intv
    gotolabel
    add_intv add_int sub_intv sub_int
    hasfirst_str first_str delfirst_str
    cvt_str_int cvt_int_str
    append_strv append_str
    read_str write_strv write_str
);

use Global;

### Registers ###

@Preg = (0, 1, 2);

sub AllocPreg {
    my $r;

    @Preg || die "Out of P registers\n";
    $r = shift @Preg;
    return "$r";
}

sub FreePreg {
    my $r = shift;

    unshift @Preg, $r;
}

@Ireg = (3, 4);

sub AllocIreg {
    my $r;

    @Ireg || die "Out of I registers\n";
    $r = shift @Ireg;
    return "$r";
}

sub FreeIreg {
    my $r = shift;

    unshift @Ireg, $r;
}

@Sreg = (5, 6);

sub AllocSreg {
    my $r;

    @Sreg || die "Out of S registers\n";
    $r = shift @Sreg;
    return "$r";
}

sub FreeSreg {
    my $r = shift;

    unshift @Sreg, $r;
}

### end Registers ###

### Labels ###

sub getInstrLabel {
    my $i = shift;

    return "IL$i"
}

my $local_label_count = 0;

sub getLocalLabel {
    my $i;

    $i = $local_label_count ++;
    return "LL$i"
}

### end Labels ###

### Output ###

sub OutputComment {
    my $com = shift;

    print "// $com\n";
}

sub OutputPre {

    my $libdir = Global::Get('LIBDIR');

    print <<PRO;
.class private auto ansi beforefieldinit MSP extends System.Object {
    .field private static class [mscorlib]System.Collections.Hashtable focus

    .method private static hidebysig default void _init () cil managed {
        .entrypoint
        .locals init ( class [mscorlib]System.Collections.Hashtable V_0)
        newobj instance void class [mscorlib]System.Collections.Hashtable::.ctor
()
        stsfld  class [mscorlib]System.Collections.Hashtable MSP::focus
        newobj instance void class [mscorlib]System.Collections.Hashtable::.ctor
()
        stloc 0
        ldloc 0
        ldstr "_t"
        ldstr "atom"
        callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)
        ldsfld  class [mscorlib]System.Collections.Hashtable MSP::focus
        ldstr "null"
        ldloc 0
        callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)
        call void class MSP::Main()
        ret
    }

    .method private static hidebysig default void Main () cil managed {
    .locals init (
	class [mscorlib]System.Collections.Hashtable    V_0,
	class [mscorlib]System.Collections.Hashtable    V_1,
	class [mscorlib]System.Collections.Hashtable    V_2,
	int32   V_3,
	int32   V_4,
	string  V_5,
	string  V_6
    )

PRO
}

sub OutputPost {

    print <<PRO;

END:
        ret
    }
}

PRO
}

sub OutputInstr {
    my $s = shift;

    print "        $s\n";
}

sub OutputLabel {
    my $l = shift;
    my $s;

    if ($#_ >= 0) {
	print "    $l:        // $_[0]\n";
    } else {
	print "    $l:\n";
    }
}

### end Output ###

### instructions ###

my $class = 'MSP';

sub newatom {
    my $reg = shift;

    OutputInstr("newobj instance void class [mscorlib]System.Collections.Hashtable::.ctor()");
    OutputInstr("stloc $reg");
}

sub getfield {
    my $p = shift;
    my $reg = shift;
    my $f = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("callvirt instance object class [mscorlib]System.Collections.Hashtable::get_Item(object)");
    OutputInstr("stloc $p");
}

sub setfield {
    my $reg = shift;
    my $f = shift;
    my $p = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("ldloc $p");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)");
}

sub removefield {
    my $reg = shift;
    my $f = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::Remove(object)");
}

sub fieldexists {
    my $reg = shift;
    my $x = shift;
    my $false = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$x\"");
    OutputInstr("callvirt instance bool class [mscorlib]System.Collections.Hashtable::Contains(object)");
    OutputInstr("brfalse $false");
}

sub getfield_int {
    my $x = shift;
    my $reg = shift;
    my $f = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("callvirt instance object class [mscorlib]System.Collections.Hashtable::get_Item(object)");
    OutputInstr("unbox [mscorlib]System.Int32");
    OutputInstr("ldind.i4");
    OutputInstr("stloc $x");
}

sub setfield_int {
    my $reg = shift;
    my $f = shift;
    my $x = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("ldloc $x");
    OutputInstr("box [mscorlib]System.Int32");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)");
}

sub setfield_intv {
    my $reg = shift;
    my $f = shift;
    my $v = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("ldc.i4 $v");
    OutputInstr("box [mscorlib]System.Int32");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)");
}

sub getfield_str {
    my $x = shift;
    my $reg = shift;
    my $f = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("callvirt instance object class [mscorlib]System.Collections.Hashtable::get_Item(object)");
    OutputInstr("castclass [mscorlib]System.String");
    OutputInstr("stloc $x");
}

sub setfield_str {
    my $reg = shift;
    my $f = shift;
    my $x = shift;

    setfield($reg, $f, $x);
}

sub setfield_strv {
    my $reg = shift;
    my $f = shift;
    my $v = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr \"$f\"");
    OutputInstr("ldstr $v");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)");
}

sub gettype {
    my $sreg = shift;
    my $reg = shift;

    getfield_str($sreg, $reg, "_t");
}

sub settype {
    my $reg = shift;
    my $sreg = shift;

    setfield_str($reg, "_t", $sreg);
}

sub settype_v {
    my $reg = shift;
    my $type = shift;

    setfield_strv($reg, "_t", "\"$type\"");
}

sub getvalue {
    my $preg = shift;
    my $reg = shift;

    getfield($preg, $reg, "_v");
}

sub setvalue {
    my $reg = shift;
    my $preg = shift;

    setfield($reg, "_v", $preg);
}

sub getvalue_int {
    my $ireg = shift;
    my $reg = shift;

    getfield_int($ireg, $reg, "_v");
}

sub setvalue_int {
    my $reg = shift;
    my $ireg = shift;

    setfield_int($reg, "_v", $ireg);
}

sub setvalue_intv {
    my $reg = shift;
    my $v = shift;

    setfield_intv($reg, "_v", $v);
}

sub getvalue_str {
    my $sreg = shift;
    my $reg = shift;

    getfield_str($sreg, $reg, "_v");
}

sub setvalue_str {
    my $reg = shift;
    my $sreg = shift;

    setfield_str($reg, "_v", $sreg);
}

sub setvalue_strv {
    my $reg = shift;
    my $v = shift;

    setfield_strv($reg, "_v", $v);
}

sub getfocus {
    my $preg = shift;
    my $x = shift;

    OutputInstr("ldsfld  class [mscorlib]System.Collections.Hashtable ${class}::focus");
    OutputInstr("ldstr \"$x\"");
    OutputInstr("callvirt instance object class [mscorlib]System.Collections.Hashtable::get_Item(object)");
#    OutputInstr("castclass [mscorlib]System.Collections.Hashtable");
    OutputInstr("stloc $preg");
}

sub setfocus {
    my $x = shift;
    my $preg = shift;

    OutputInstr("ldsfld  class [mscorlib]System.Collections.Hashtable ${class}::focus");
    OutputInstr("ldstr \"$x\"");
    OutputInstr("ldloc $preg");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::set_Item(object, object)");
}

sub removefocus {
    my $x = shift;

    OutputInstr("ldsfld  class [mscorlib]System.Collections.Hashtable ${class}::focus");
    OutputInstr("ldstr \"$x\"");
    OutputInstr("callvirt instance void class [mscorlib]System.Collections.Hashtable::Remove(object)");
}

sub focusexists {
    my $x = shift;
    my $false = shift;

    OutputInstr("ldsfld  class [mscorlib]System.Collections.Hashtable ${class}::focus");
    OutputInstr("ldstr \"$x\"");
    OutputInstr("callvirt instance bool class [mscorlib]System.Collections.Hashtable::Contains(object)");
    OutputInstr("brfalse $false");
}

sub equal {
    my $p1 = shift;
    my $p2 = shift;
    my $false = shift;

    OutputInstr("ldloc $p1");
    OutputInstr("ldloc $p2");
    OutputInstr("bne.un $false");
}

sub notequal {
    my $p1 = shift;
    my $p2 = shift;
    my $false = shift;

    OutputInstr("ldloc $p1");
    OutputInstr("ldloc $p2");
    OutputInstr("beq $false");
}

sub equal_str {
    my $s1 = shift;
    my $s2 = shift;
    my $false = shift;

    OutputInstr("ldloc $s1");
    OutputInstr("ldloc $s2");
    OutputInstr("call bool valuetype [mscorlib]System.String::Equals(string, string)");
    OutputInstr("brfalse $false");
}

sub equal_strv {
    my $s = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("ldloc $s");
    OutputInstr("ldstr $v");
    OutputInstr("call bool valuetype [mscorlib]System.String::Equals(string, string)");
    OutputInstr("brfalse $false");
}

sub equal_int {
    my $i1 = shift;
    my $i2 = shift;
    my $false = shift;

    OutputInstr("ldloc $i1");
    OutputInstr("ldloc $i2");
    OutputInstr("bne.un $false");
}

sub equal_intv {
    my $i1 = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("ldloc $i1");
    OutputInstr("ldc.i4 $v");
    OutputInstr("bne.un $false");
}

sub gotolabel {
    my $l = shift;

    OutputInstr("br $l");
}

### end instructions ###

### MSPio instructions ###

sub add_intv {
    my $reg1 = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("ldloc $reg1");
    OutputInstr("ldc.i4 $v");
    OutputInstr("add");
    OutputInstr("stloc $reg1");
}

sub add_int {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("ldloc $reg1");
    OutputInstr("ldloc $reg2");
    OutputInstr("add");
    OutputInstr("stloc $reg1");
}

sub sub_intv {
    my $reg1 = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("ldloc $reg1");
    OutputInstr("ldc.i4 $v");
    OutputInstr("blt $false");
    OutputInstr("ldloc $reg1");
    OutputInstr("ldc.i4 $v");
    OutputInstr("sub");
    OutputInstr("stloc $reg1");
}

sub sub_int {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("ldloc $reg1");
    OutputInstr("ldloc $reg2");
    OutputInstr("blt $false");
    OutputInstr("ldloc $reg1");
    OutputInstr("ldloc $reg2");
    OutputInstr("sub");
    OutputInstr("stloc $reg1");
}

sub hasfirst_str {
    my $reg = shift;
    my $false = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("callvirt instance int32 valuetype [mscorlib]System.String::get_Length()");
    OutputInstr("ldc.i4 0");
    OutputInstr("beq $false");
}

sub first_str {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("ldloc $reg2");
    OutputInstr("ldc.i4 0");
    OutputInstr("callvirt instance char valuetype [mscorlib]System.String::get_Chars(int32)");
    OutputInstr("ldc.i4 1");
    OutputInstr("newobj instance void valuetype [mscorlib]System.String::.ctor(char, int32)");
    OutputInstr("stloc $reg1");
}

sub delfirst_str {
    my $reg = shift;
    my $false = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldc.i4 0");
    OutputInstr("ldc.i4 1");
    OutputInstr("callvirt instance string valuetype [mscorlib]System.String::Remove(int32, int32)");
    OutputInstr("stloc $reg");
}

sub cvt_str_int {
    my $ireg = shift;
    my $sreg = shift;
    my $false = shift;
    my $end = getLocalLabel();

    OutputInstr(".try {");
    OutputInstr("ldloc $sreg");
    OutputInstr("call int32 valuetype [mscorlib]System.Int32::Parse(string)"
);
    OutputInstr("stloc $ireg");
    OutputInstr("leave $end");
    OutputInstr("}");
    OutputInstr("catch [mscorlib]System.Exception {");
    OutputInstr("leave $false");
    OutputInstr("}");
    OutputLabel($end);
}

sub cvt_int_str {
    my $sreg = shift;
    my $ireg = shift;
    my $false = shift;

    OutputInstr("ldloca.s $ireg");
    OutputInstr("call instance string valuetype [mscorlib]System.Int32::ToString()");
    OutputInstr("stloc $sreg");
}

sub append_strv {
    my $reg = shift;
    my $v = shift;
    my $false = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("ldstr $v");
    OutputInstr("call string valuetype [mscorlib]System.String::Concat(string, string)");
    OutputInstr("stloc $reg");
}

sub append_str {
    my $reg1 = shift;
    my $reg2 = shift;
    my $false = shift;

    OutputInstr("ldloc $reg1");
    OutputInstr("ldloc $reg2");
    OutputInstr("call string valuetype [mscorlib]System.String::Concat(string, string)");
    OutputInstr("stloc $reg1");
}

sub read_str {
    my $sreg = shift;
    my $false = shift;
    my $ireg;

    $ireg = AllocIreg();
    OutputInstr("call int32 class [mscorlib]System.Console::Read()");
    OutputInstr("stloc $ireg");
    OutputInstr("ldloc $ireg");
    OutputInstr("ldc.i4 0");
    OutputInstr("blt $false");
    OutputInstr("ldloc $ireg");
    OutputInstr("conv.u2");
    OutputInstr("ldc.i4 1");
    OutputInstr("newobj instance void valuetype [mscorlib]System.String::.ctor(char, int32)");
    OutputInstr("stloc $sreg");
    FreeIreg($ireg);
}

sub write_strv {
    my $v = shift;
    my $false = shift;

    OutputInstr("ldstr $v");
    OutputInstr("call void class [mscorlib]System.Console::Write(string)");
}

sub write_str {
    my $reg = shift;
    my $false = shift;

    OutputInstr("ldloc $reg");
    OutputInstr("call void class [mscorlib]System.Console::Write(string)");
}

### end MSPio instructions ###

1;
