
package Breakpoint;

$VERSION = "0.00";

sub BreakpointSet {
    my $self = shift;
    my $bp = shift;

    $break{$bp} = 1;
}

sub BreakpointUnset {
    my $self = shift;
    my $bp = shift;

    if (defined $break{$bp}) {
        delete $break{$bp};
    }
}

sub BreakpointOn {
    my $self = shift;
    my $pc = shift;

    if (defined $break{$pc}) {
	return 1;
    } else {
	return 0;
    }
}

sub ClearBreakpoints {
    undef %break;
}

sub PrintBreakpoints {
    my $self = shift;

    if (($s = join(" ", keys %break)) eq "") {
	$main::ui->Msg("no breakpoints set\n");
    } else {
	$main::ui->Msg("breaks on: $s\n");
    }
}

1;
