
package BiSim;

$VERSION = "0.00";

use BiSimArray;
use BiSimQueue;

sub branching {
    my $ts = shift;
    my $nr = shift;
    my $l = shift;
    my $nrjumps;
    my @jump;
    my $i;

    $nrjumps = 0;
#    while ($#{$$l} == 0 && ${$$l}[0] == 0) { # tau
    while (${$$l}[0] == 0) { # tau
	$jump[$nrjumps ++] = $$nr;
        $$nr = $ts->Transit($$nr, 0);
	$$l = $ts->GetLabels($$nr);
#print STDERR "newbr $$nr ", join(",", @{$$l}), "\n";
	for ($i = 0; $i < $nrjumps; $i ++) {
	    if ($jump[$i] == $$nr) {
		return 2;
	    }
	}
    }
    return 0;
}

sub transitionlistcmp {
    my $l1 = shift;
    my $l2 = shift;
    my $i;

    if ($#{$l1} != $#{$l2}) {
	return 0;
    }
    if ($#{$l1} == 0) {
	return -1;
    }
#    for ($i = 0; $i <= $#{$l1}; $i ++) {
    for ($i = $#{$l1}; $i >= 0; $i --) {
	if (${$l1}[$i] != ${$l2}[$i]) {
	    return 0;
	}
    }
    return 1;
}

sub ProgramBranching {
    my $ts1 = shift;
    my $nr1 = shift;
    my $l1 = shift;
    my $ts2 = shift;
    my $nr2 = shift;
    my $l2 = shift;
    my $jumped1;
    my $jumped2;
    my $r;
    my $i;
    my $ns1;
    my $ns2;

    $jumped1 = branching($ts1, \$nr1, \$l1);
#print STDERR "br1 $jumped1 $nr1 ", join(",", @{$l1}), "\n";
    $jumped2 = branching($ts2, \$nr2, \$l2);
#print STDERR "br2 $jumped2 $nr2 ", join(",", @{$l2}), "\n";
    if ($jumped1 == 2 || $jumped2 == 2) {
	if ($jumped1 == 2 && $jumped2 == 2) {
	    return 1;
	} else {
	    return 0;
	}
    }
    $r = transitionlistcmp($l1, $l2);
#print STDERR "tlc $r\n";
    if ($r > 0) { # same
	BiSimArray->Set($nr1, $nr2);
	for ($i = $#{$l1}; $i >= 0; $i --) {
	    $ns1 = $ts1->Transit($nr1, ${$l1}[$i]);
	    $ns2 = $ts2->Transit($nr2, ${$l2}[$i]);
#print STDERR "next $ns1 - $ns2\n";
	    if (! BiSimArray->Get($ns1, $ns2)) {
		BiSimQueue->Add($ns1, $ns2);
	    }
	}
	return 1;
    } elsif ($r == 0) { # diff
	return 0;
    } else { # end states
	return 1;
    }
}

sub bisim {
    my $ts1 = shift;
    my $ts2 = shift;

    while (($nr1, $nr2) = BiSimQueue->Get) {
#print STDERR "do: $nr1 - $nr2\n";
	$l1 = $ts1->GetLabels($nr1);
	$l2 = $ts2->GetLabels($nr2);
	if (! ProgramBranching($ts1, $nr1, $l1, $ts2, $nr2, $l2)) {
	    return 0;
	}
    }
    return 1;
}
	
sub Test {
    my $self = shift;
    my $ts1 = shift;
    my $ts2 = shift;

    BiSimArray->Init($ts1->NrStates, $ts2->NrStates);
    BiSimQueue->Add(0, 0);
    if (! bisim($ts1, $ts2)) {
	return 0;
    } else {
	return 1;
    }
}

1;
