
package BPP;

$VERSION = "0.02";

use Global;

if (defined $::toolbus) {
    if (! eval {require "BI_TB.pm"}) {
	die "module BI_TB not found\n";
    }
    @ISA = qw( BI_TB );
} else {
    if (! eval {require "BPPcore.pm"}) {
	die "module BPPcore not found\n";
    }
    @ISA = qw( BPPcore );
}

$number = '[0-9]|[1-9][0-9]*';
$bool = 'true|false';
$tprop = 'in|out|aux';
$tpropset = 'out|aux';
$tpropget = 'in|aux';
$sbool = 't|f';
$stprop = 'i|o|a';
$stpropset = 'o|a';
$stpropget = 'i|a';
%s2l = ( 'i' => 'IN', 'a' => 'AUX', 'o' => 'OUT' );
%l2s = ( 'IN' => 'i', 'AUX' => 'a', 'OUT' => 'o' );
%sbool = ( 'true' => 't', 'false' => 'f' );
%lbool = ( 't' => 'true', 'f' => 'false' );

sub Parse {
    my $self = shift;
    my $i = shift;
    my @prim;

    if ($i =~ /^\s*(.*\S)\s*$/) {
	$i = $1;
    }
    if ($i =~ /^($tpropset)b($number)\.set:($bool)$/) {
	@prim = ( 'SET', uc($1), $2, $3, 'LONG' );
	BPPcore->InitProp(uc($1), $2);
    } elsif ($i =~ /^($tpropget)b($number)\.get$/) {
	@prim = ( 'GET', uc($1), $2, 'LONG' );
	BPPcore->InitProp(uc($1), $2);
    } elsif ($i =~ /^($tprop)b($number)\.is:($bool)$/) {
	@prim = ( 'IS', uc($1), $2, $3, 'LONG' );
	BPPcore->InitProp(uc($1), $2);
    } elsif ($i =~ /^($stpropset)($number)(\.)?s($sbool)$/) {
	if ($3 eq '.') {
	    $notation = 'SHORTDOT';
	} else {
	    $notation = 'SHORT';
	}
	@prim = ( 'SET', $s2l{$1}, $2, $lbool{$4}, $notation );
	BPPcore->InitProp($s2l{$1}, $2);
    } elsif ($i =~ /^($stpropget)($number)(\.)?g$/) {
	if ($3 eq '.') {
	    $notation = 'SHORTDOT';
	} else {
	    $notation = 'SHORT';
	}
	@prim = ( 'GET', $s2l{$1}, $2, $notation );
	BPPcore->InitProp($s2l{$1}, $2);
    } elsif ($i =~ /^($stprop)($number)(\.)?is($sbool)$/) {
	if ($3 eq '.') {
	    $notation = 'SHORTDOT';
	} else {
	    $notation = 'SHORT';
	}
	@prim = ( 'IS', $s2l{$1}, $2, $lbool{$4}, $notation );
	BPPcore->InitProp($s2l{$1}, $2);
    } else {
	@prim = ( 'ERROR' );
#	print "\nunknown primitive: $i\n";
    }
#    print "prim: " . join("*", @prim) . "\n";
    return @prim
}

sub Print {
    my $self = shift;
    my @i = @_;
    my $opc;
    my $tp;
    my $n;
    my $v;

    $opc = shift @i;
#    print "$opc(" . join(", ", @i) . ")";
    if ($opc eq 'SET') {
	$tp = shift @i;
	$n = shift @i;
	$v = shift @i;
	$notation = shift @i;
	if ($notation eq 'LONG') {
	    return lc(${tp}) . "b${n}.set:${v}";
	} elsif ($notation eq 'SHORTDOT') {
	    return $l2s{$tp} . "${n}.s$sbool{$v}";
	} else {
	    return $l2s{$tp} . "${n}s$sbool{$v}";
	}
    } elsif ($opc eq 'GET') {
	$tp = shift @i;
	$n = shift @i;
	$notation = shift @i;
	if ($notation eq 'LONG') {
	    return lc(${tp}) . "b${n}.get";
	} elsif ($notation eq 'SHORTDOT') {
	    return $l2s{$tp} . "${n}.g";
	} else {
	    return $l2s{$tp} . "${n}g";
	}
    } elsif ($opc eq 'IS') {
	$tp = shift @i;
	$n = shift @i;
	$v = shift @i;
	$notation = shift @i;
	if ($notation eq 'LONG') {
	    return lc(${tp}) . "b${n}.is:${v}";
	} elsif ($notation eq 'SHORTDOT') {
	    return $l2s{$tp} . "${n}.is$sbool{$v}";
	} else {
	    return $l2s{$tp} . "${n}is$sbool{$v}";
	}
    }
}

1;
