
package BI_TB;

$VERSION = "0.04";

use TB;

$init = 0;

sub InitCore {
    if (! $init) {
	# autoflush of output
	my $oldfh = select STDOUT; $| = 1; select $oldfh;
	$init = 1;
    } else {
	TB->Send("reset");
	$ack = TB->Receive;
    }
}

sub Exec {
    my $self = shift;
    my @i = @_;

    # separator (see also tb-core)
    $arg = join("___", @i);
    $arg =~ s/\"/\\\"/g;
    TB->Send("exec($arg)");
    $ack = TB->Receive;
    if ($ack =~ /^ack\((\d)\)$/) {
	return $1;
#    } elsif ($ack =~ /^ack\((.+)\)$/) {
#    # is this case necessary?
#        return $1;
    } elsif ($ack =~ /^q$/) {
        exit 0;
    } else {
	print STDERR "something wrong '$ack'\n";
	return 0;
    }
}

sub DumpCore {
    TB->Send("dumpcore");
    TB->Receive;
}

$coreviewupdate = 1;

sub SetUpdate {
    my $self = shift;
    my $update = shift;

    $coreviewupdate = $update;
    TB->Send("doupdates($update)");
    TB->Receive;
}

sub Update {
    if ($coreviewupdate == 0) {
	TB->Send("update");
	TB->Receive;
    }
}

END {
    TB->Send("quit");
}

1;
